/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authentication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authentication.Authentication;
import me.ahoo.cosec.api.authentication.AuthenticationProvider;
import me.ahoo.cosec.api.authentication.Credentials;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\f\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\u000e*\u00020\u0006\"\b\b\u0001\u0010\u000f*\u00020\b\"\u0014\b\u0002\u0010\r*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011JM\u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u000e*\u00020\u0006\"\b\b\u0001\u0010\u000f*\u00020\b\"\u0014\b\u0002\u0010\r*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00052\u0006\u0010\u0014\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0015R0\u0010\u0003\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0012\u0012\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosec/authentication/DefaultAuthenticationProvider;", "Lme/ahoo/cosec/api/authentication/AuthenticationProvider;", "()V", "authenticationMaps", "", "Ljava/lang/Class;", "Lme/ahoo/cosec/api/authentication/Credentials;", "Lme/ahoo/cosec/api/authentication/Authentication;", "Lme/ahoo/cosec/api/principal/CoSecPrincipal;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "get", "A", "C", "P", "credentialsType", "(Ljava/lang/Class;)Lme/ahoo/cosec/api/authentication/Authentication;", "register", "", "authentication", "(Ljava/lang/Class;Lme/ahoo/cosec/api/authentication/Authentication;)V", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nDefaultAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAuthenticationProvider.kt\nme/ahoo/cosec/authentication/DefaultAuthenticationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n288#2,2:62\n*S KotlinDebug\n*F\n+ 1 DefaultAuthenticationProvider.kt\nme/ahoo/cosec/authentication/DefaultAuthenticationProvider\n*L\n54#1:62,2\n*E\n"})
public final class DefaultAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    public static final DefaultAuthenticationProvider INSTANCE = new DefaultAuthenticationProvider();
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticationProvider.class);
    @NotNull
    private static final Map<Class<? extends Credentials>, Authentication<? extends Credentials, CoSecPrincipal>> authenticationMaps = new ConcurrentHashMap();

    private DefaultAuthenticationProvider() {
    }

    public <C extends Credentials, P extends CoSecPrincipal, A extends Authentication<C, ? extends P>> void register(@NotNull Class<C> credentialsType, @NotNull A authentication) {
        Intrinsics.checkNotNullParameter(credentialsType, (String)"credentialsType");
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        if (log.isInfoEnabled()) {
            log.info("Register Authentication: {} for Credentials: {}", authentication, credentialsType);
        }
        authenticationMaps.put(credentialsType, authentication);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <C extends Credentials, P extends CoSecPrincipal, A extends Authentication<C, ? extends P>> A get(@NotNull Class<? extends Credentials> credentialsType) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(credentialsType, (String)"credentialsType");
            Authentication<? extends Credentials, CoSecPrincipal> authentication = authenticationMaps.get(credentialsType);
            if (authentication != null) {
                return (A)authentication;
            }
            Iterable iterable = authenticationMaps.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Authentication it = (Authentication)element$iv;
                boolean bl = false;
                if (!it.getSupportCredentials().isAssignableFrom(credentialsType)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Authentication authentication = v0;
        if (authentication != null) {
            Authentication it = authentication;
            boolean bl = false;
            return (A)it;
        }
        return null;
    }
}

