/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.condition.part;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.policy.condition.part.PartExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lme/ahoo/cosec/policy/condition/part/DefaultPartExtractor;", "Lme/ahoo/cosec/policy/condition/part/PartExtractor;", "part", "", "(Ljava/lang/String;)V", "getPart", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "extract", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "hashCode", "", "toString", "cosec-core"})
public final class DefaultPartExtractor
implements PartExtractor {
    @NotNull
    private final String part;

    public DefaultPartExtractor(@NotNull String part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        this.part = part;
    }

    @NotNull
    public final String getPart() {
        return this.part;
    }

    @Override
    @NotNull
    public String extract(@NotNull Request request, @NotNull SecurityContext securityContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        switch (this.part) {
            case "request.path": {
                string = request.getPath();
                break;
            }
            case "request.method": {
                string = request.getMethod();
                break;
            }
            case "request.remoteIp": {
                string = request.getRemoteIp();
                break;
            }
            case "request.origin": {
                string = request.getOrigin();
                break;
            }
            case "request.referer": {
                string = request.getReferer();
                break;
            }
            case "context.tenantId": {
                string = securityContext.getTenant().getTenantId();
                break;
            }
            case "context.principal.id": {
                string = securityContext.getPrincipal().getId();
                break;
            }
            default: {
                if (StringsKt.startsWith$default((String)this.part, (String)"request.header.", (boolean)false, (int)2, null)) {
                    String string2 = this.part.substring(15);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    String headerKey = string2;
                    return request.getHeader(headerKey);
                }
                if (StringsKt.startsWith$default((String)this.part, (String)"context.principal.attributes.", (boolean)false, (int)2, null)) {
                    String string3 = this.part.substring(29);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    String headerKey = string3;
                    String string4 = (String)securityContext.getPrincipal().getAttributes().get(headerKey);
                    if (string4 == null) {
                        string4 = "";
                    }
                    return string4;
                }
                throw new IllegalArgumentException("Unsupported part: " + this.part);
            }
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.part;
    }

    @NotNull
    public final DefaultPartExtractor copy(@NotNull String part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        return new DefaultPartExtractor(part);
    }

    public static /* synthetic */ DefaultPartExtractor copy$default(DefaultPartExtractor defaultPartExtractor, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = defaultPartExtractor.part;
        }
        return defaultPartExtractor.copy(string);
    }

    @NotNull
    public String toString() {
        return "DefaultPartExtractor(part=" + this.part + ')';
    }

    public int hashCode() {
        return this.part.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultPartExtractor)) {
            return false;
        }
        DefaultPartExtractor defaultPartExtractor = (DefaultPartExtractor)other;
        return Intrinsics.areEqual((Object)this.part, (Object)defaultPartExtractor.part);
    }
}

