/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.policy.ConditionMatcher;
import me.ahoo.cosec.policy.AllConditionMatcher;
import me.ahoo.cosec.policy.AuthenticatedConditionMatcher;
import me.ahoo.cosec.policy.InDefaultTenantConditionMatcher;
import me.ahoo.cosec.policy.InPlatformTenantConditionMatcher;
import me.ahoo.cosec.policy.InUserTenantConditionMatcher;
import me.ahoo.cosec.policy.NoneConditionMatcher;
import me.ahoo.cosec.policy.OgnlConditionMatcher;
import me.ahoo.cosec.policy.SpelConditionMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lme/ahoo/cosec/policy/ConditionMatcherFactory;", "", "()V", "create", "Lme/ahoo/cosec/api/policy/ConditionMatcher;", "type", "", "pattern", "cosec-core"})
public final class ConditionMatcherFactory {
    @NotNull
    public static final ConditionMatcherFactory INSTANCE = new ConditionMatcherFactory();

    private ConditionMatcherFactory() {
    }

    @NotNull
    public final ConditionMatcher create(@NotNull String type, @NotNull String pattern) {
        ConditionMatcher conditionMatcher;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = type.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (string) {
            case "all": {
                conditionMatcher = AllConditionMatcher.INSTANCE;
                break;
            }
            case "none": {
                conditionMatcher = NoneConditionMatcher.INSTANCE;
                break;
            }
            case "authenticated": {
                conditionMatcher = AuthenticatedConditionMatcher.INSTANCE;
                break;
            }
            case "in_default_tenant": {
                conditionMatcher = InDefaultTenantConditionMatcher.INSTANCE;
                break;
            }
            case "in_platform_tenant": {
                conditionMatcher = InPlatformTenantConditionMatcher.INSTANCE;
                break;
            }
            case "in_user_tenant": {
                conditionMatcher = InUserTenantConditionMatcher.INSTANCE;
                break;
            }
            case "spel": {
                conditionMatcher = new SpelConditionMatcher(pattern);
                break;
            }
            case "ognl": {
                conditionMatcher = new OgnlConditionMatcher(pattern);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ConditionMatcher type: " + type);
            }
        }
        return conditionMatcher;
    }
}

