/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.policy.Effect;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.api.policy.Statement;
import me.ahoo.cosec.api.policy.VerifyResult;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.api.tenant.Tenant;
import me.ahoo.cosec.authorization.IllegalTenantContextException;
import me.ahoo.cosec.authorization.PermissionRepository;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization;", "Lme/ahoo/cosec/api/authorization/Authorization;", "permissionRepository", "Lme/ahoo/cosec/authorization/PermissionRepository;", "(Lme/ahoo/cosec/authorization/PermissionRepository;)V", "authorize", "Lreactor/core/publisher/Mono;", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "request", "Lme/ahoo/cosec/api/context/request/Request;", "context", "Lme/ahoo/cosec/api/context/SecurityContext;", "verifyGlobalPolicies", "Lme/ahoo/cosec/api/policy/VerifyResult;", "verifyPolicies", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "verifyPrincipalPolicies", "verifyRolePolicies", "verifyRoot", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nSimpleAuthorization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1855#2:139\n766#2:140\n857#2,2:141\n1855#2,2:143\n1856#2:145\n1855#2:146\n766#2:147\n857#2,2:148\n1855#2,2:150\n1856#2:152\n*S KotlinDebug\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n*L\n36#1:139\n37#1:140\n37#1:141,2\n39#1:143,2\n36#1:145\n47#1:146\n48#1:147\n48#1:148,2\n50#1:150,2\n47#1:152\n*E\n"})
public final class SimpleAuthorization
implements Authorization {
    @NotNull
    private final PermissionRepository permissionRepository;

    public SimpleAuthorization(@NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        this.permissionRepository = permissionRepository;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyResult verifyPolicies(Set<? extends Policy> policies, Request request, SecurityContext context) {
        VerifyResult verifyResult;
        void $this$forEach$iv;
        boolean $i$f$forEach;
        Statement statement;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        Policy policy;
        Iterable $this$forEach$iv2 = policies;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                statement = (Statement)element$iv$iv;
                boolean bl2 = false;
                if (!(statement.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$filterTo$iv$iv.next();
                Statement statement2 = (Statement)element$iv2;
                boolean bl3 = false;
                verifyResult = statement2.verify(request, context);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                return VerifyResult.EXPLICIT_DENY;
            }
        }
        $this$forEach$iv2 = policies;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl3 = $this$filterTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                element$iv$iv = bl3.next();
                statement = (Statement)element$iv$iv;
                boolean bl4 = false;
                if (!(statement.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Statement statement3 = (Statement)element$iv2;
                boolean bl5 = false;
                verifyResult = statement3.verify(request, context);
                if (verifyResult != VerifyResult.ALLOW) continue;
                return VerifyResult.ALLOW;
            }
        }
        return VerifyResult.IMPLICIT_DENY;
    }

    private final VerifyResult verifyRoot(SecurityContext context) {
        return CoSecPrincipal.Companion.isRoot(context.getPrincipal()) ? VerifyResult.ALLOW : VerifyResult.IMPLICIT_DENY;
    }

    private final Mono<VerifyResult> verifyGlobalPolicies(Request request, SecurityContext context) {
        Mono mono = this.permissionRepository.getGlobalPolicy().defaultIfEmpty((Object)SetsKt.emptySet()).map(arg_0 -> SimpleAuthorization.verifyGlobalPolicies$lambda$6((Function1)new Function1<Set<? extends Policy>, VerifyResult>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyResult invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyGlobal\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyResult> verifyPrincipalPolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getPolicies().isEmpty()) {
            return MonoExtensionsKt.toMono((Object)VerifyResult.IMPLICIT_DENY);
        }
        Mono mono = this.permissionRepository.getPolicies(context.getPrincipal().getPolicies()).defaultIfEmpty((Object)SetsKt.emptySet()).map(arg_0 -> SimpleAuthorization.verifyPrincipalPolicies$lambda$7((Function1)new Function1<Set<? extends Policy>, VerifyResult>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyResult invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyPrinci\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyResult> verifyRolePolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getRoles().isEmpty()) {
            return MonoExtensionsKt.toMono((Object)VerifyResult.IMPLICIT_DENY);
        }
        Mono mono = this.permissionRepository.getRolePolicy(context.getPrincipal().getRoles()).defaultIfEmpty((Object)SetsKt.emptySet()).map(arg_0 -> SimpleAuthorization.verifyRolePolicies$lambda$8((Function1)new Function1<Set<? extends Policy>, VerifyResult>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyResult invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyRolePo\u2026text)\n            }\n    }");
        return mono;
    }

    @NotNull
    public Mono<AuthorizeResult> authorize(@NotNull Request request, @NotNull SecurityContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VerifyResult verifyResult = this.verifyRoot(context);
        if (verifyResult == VerifyResult.ALLOW) {
            return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getALLOW());
        }
        if (context.getPrincipal().authenticated() && !Intrinsics.areEqual((Object)Tenant.DEFAULT_TENANT_ID, (Object)request.getTenantId()) && !Intrinsics.areEqual((Object)request.getTenantId(), (Object)context.getTenant().getTenantId())) {
            return MonoExtensionsKt.toMono((Throwable)new IllegalTenantContextException((Tenant)request, context));
        }
        Mono mono = this.verifyGlobalPolicies(request, context).flatMap(arg_0 -> SimpleAuthorization.authorize$lambda$9((Function1)new Function1<VerifyResult, Mono<? extends VerifyResult>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final Mono<? extends VerifyResult> invoke(@NotNull VerifyResult globalVerifyResult) {
                Intrinsics.checkNotNullParameter((Object)globalVerifyResult, (String)"globalVerifyResult");
                if (globalVerifyResult == VerifyResult.IMPLICIT_DENY) {
                    return SimpleAuthorization.access$verifyPrincipalPolicies(this.this$0, this.$request, this.$context);
                }
                return MonoExtensionsKt.toMono((Object)globalVerifyResult);
            }
        }, arg_0)).flatMap(arg_0 -> SimpleAuthorization.authorize$lambda$10((Function1)new Function1<VerifyResult, Mono<? extends AuthorizeResult>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final Mono<? extends AuthorizeResult> invoke(@NotNull VerifyResult principalVerifyResult) {
                Mono mono;
                Intrinsics.checkNotNullParameter((Object)principalVerifyResult, (String)"principalVerifyResult");
                switch (authorize.WhenMappings.$EnumSwitchMapping$0[principalVerifyResult.ordinal()]) {
                    case 1: {
                        mono = MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getALLOW());
                        break;
                    }
                    case 2: {
                        mono = MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getEXPLICIT_DENY());
                        break;
                    }
                    case 3: {
                        Mono mono2 = SimpleAuthorization.access$verifyRolePolicies(this.this$0, this.$request, this.$context).map(arg_0 -> authorize.2.invoke$lambda$0(authorize.1.INSTANCE, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"{\n                      \u2026  }\n                    }");
                        mono = mono2;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return mono;
            }

            private static final AuthorizeResult invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (AuthorizeResult)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun authorize(r\u2026    }\n            }\n    }");
        return mono;
    }

    private static final VerifyResult verifyGlobalPolicies$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyResult)$tmp0.invoke(p0);
    }

    private static final VerifyResult verifyPrincipalPolicies$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyResult)$tmp0.invoke(p0);
    }

    private static final VerifyResult verifyRolePolicies$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyResult)$tmp0.invoke(p0);
    }

    private static final Mono authorize$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono authorize$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VerifyResult access$verifyPolicies(SimpleAuthorization $this, Set policies, Request request, SecurityContext context) {
        return $this.verifyPolicies(policies, request, context);
    }

    public static final /* synthetic */ Mono access$verifyPrincipalPolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyPrincipalPolicies(request, context);
    }

    public static final /* synthetic */ Mono access$verifyRolePolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyRolePolicies(request, context);
    }
}

