/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.policy.ConditionMatcher;
import me.ahoo.cosec.policy.ActionMatchersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.expression.Expression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lme/ahoo/cosec/policy/SpelConditionMatcher;", "Lme/ahoo/cosec/api/policy/ConditionMatcher;", "pattern", "", "(Ljava/lang/String;)V", "expression", "Lorg/springframework/expression/Expression;", "getPattern", "()Ljava/lang/String;", "type", "getType", "component1", "copy", "equals", "", "other", "", "hashCode", "", "match", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "toString", "Companion", "Root", "cosec-core"})
public final class SpelConditionMatcher
implements ConditionMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final Expression expression;
    @NotNull
    public static final String TYPE = "spel";

    public SpelConditionMatcher(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        Expression expression = ActionMatchersKt.getSPEL_PARSER().parseExpression(this.getPattern());
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"SPEL_PARSER.parseExpression(pattern)");
        this.expression = expression;
    }

    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    public boolean match(@NotNull Request request, @NotNull SecurityContext securityContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        Root root = new Root(request, securityContext);
        Object object = this.expression.getValue((Object)root, Boolean.TYPE);
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    @NotNull
    public final String component1() {
        return this.getPattern();
    }

    @NotNull
    public final SpelConditionMatcher copy(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new SpelConditionMatcher(pattern);
    }

    public static /* synthetic */ SpelConditionMatcher copy$default(SpelConditionMatcher spelConditionMatcher, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = spelConditionMatcher.getPattern();
        }
        return spelConditionMatcher.copy(string);
    }

    @NotNull
    public String toString() {
        return "SpelConditionMatcher(pattern=" + this.getPattern() + ')';
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpelConditionMatcher)) {
            return false;
        }
        SpelConditionMatcher spelConditionMatcher = (SpelConditionMatcher)other;
        return Intrinsics.areEqual((Object)this.getPattern(), (Object)spelConditionMatcher.getPattern());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/cosec/policy/SpelConditionMatcher$Companion;", "", "()V", "TYPE", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lme/ahoo/cosec/policy/SpelConditionMatcher$Root;", "", "request", "Lme/ahoo/cosec/api/context/request/Request;", "context", "Lme/ahoo/cosec/api/context/SecurityContext;", "(Lme/ahoo/cosec/api/context/request/Request;Lme/ahoo/cosec/api/context/SecurityContext;)V", "getContext", "()Lme/ahoo/cosec/api/context/SecurityContext;", "getRequest", "()Lme/ahoo/cosec/api/context/request/Request;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cosec-core"})
    public static final class Root {
        @NotNull
        private final Request request;
        @NotNull
        private final SecurityContext context;

        public Root(@NotNull Request request, @NotNull SecurityContext context) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.request = request;
            this.context = context;
        }

        @NotNull
        public final Request getRequest() {
            return this.request;
        }

        @NotNull
        public final SecurityContext getContext() {
            return this.context;
        }

        @NotNull
        public final Request component1() {
            return this.request;
        }

        @NotNull
        public final SecurityContext component2() {
            return this.context;
        }

        @NotNull
        public final Root copy(@NotNull Request request, @NotNull SecurityContext context) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Root(request, context);
        }

        public static /* synthetic */ Root copy$default(Root root, Request request, SecurityContext securityContext, int n, Object object) {
            if ((n & 1) != 0) {
                request = root.request;
            }
            if ((n & 2) != 0) {
                securityContext = root.context;
            }
            return root.copy(request, securityContext);
        }

        @NotNull
        public String toString() {
            return "Root(request=" + this.request + ", context=" + this.context + ')';
        }

        public int hashCode() {
            int result = this.request.hashCode();
            result = result * 31 + this.context.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Root)) {
                return false;
            }
            Root root = (Root)other;
            if (!Intrinsics.areEqual((Object)this.request, (Object)root.request)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.context, (Object)root.context);
        }
    }
}

