/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.condition.limiter;

import com.google.common.util.concurrent.RateLimiter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.policy.ConditionMatcher;
import me.ahoo.cosec.policy.condition.limiter.TooManyRequestsException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lme/ahoo/cosec/policy/condition/limiter/RateLimiterConditionMatcher;", "Lme/ahoo/cosec/api/policy/ConditionMatcher;", "configuration", "Lme/ahoo/cosec/api/configuration/Configuration;", "(Lme/ahoo/cosec/api/configuration/Configuration;)V", "getConfiguration", "()Lme/ahoo/cosec/api/configuration/Configuration;", "permitsPerSecond", "", "rateLimiter", "Lcom/google/common/util/concurrent/RateLimiter;", "type", "", "getType", "()Ljava/lang/String;", "match", "", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "cosec-core"})
public final class RateLimiterConditionMatcher
implements ConditionMatcher {
    @NotNull
    private final Configuration configuration;
    private final double permitsPerSecond;
    @NotNull
    private final RateLimiter rateLimiter;

    public RateLimiterConditionMatcher(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        Configuration configuration2 = this.getConfiguration().get("permitsPerSecond");
        if (configuration2 == null) {
            RateLimiterConditionMatcher rateLimiterConditionMatcher = this;
            boolean bl = false;
            RateLimiterConditionMatcher rateLimiterConditionMatcher2 = rateLimiterConditionMatcher;
            String string = "permitsPerSecond is required!";
            throw new IllegalArgumentException(string.toString());
        }
        this.permitsPerSecond = configuration2.asDouble();
        RateLimiter rateLimiter = RateLimiter.create((double)this.permitsPerSecond);
        Intrinsics.checkNotNullExpressionValue((Object)rateLimiter, (String)"create(permitsPerSecond)");
        this.rateLimiter = rateLimiter;
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getType() {
        return "rateLimiter";
    }

    public boolean match(@NotNull Request request, @NotNull SecurityContext securityContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        if (this.rateLimiter.tryAcquire()) {
            return true;
        }
        throw new TooManyRequestsException();
    }
}

