/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.permission.Permission;
import me.ahoo.cosec.api.permission.RolePermission;
import me.ahoo.cosec.api.policy.Effect;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.api.policy.Statement;
import me.ahoo.cosec.api.policy.VerifyResult;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.authorization.PolicyVerifyContext;
import me.ahoo.cosec.authorization.RolePermissionRepository;
import me.ahoo.cosec.authorization.RoleVerifyContext;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import me.ahoo.cosec.authorization.VerifyContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization;", "Lme/ahoo/cosec/api/authorization/Authorization;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "rolePermissionRepository", "Lme/ahoo/cosec/authorization/RolePermissionRepository;", "(Lme/ahoo/cosec/authorization/PolicyRepository;Lme/ahoo/cosec/authorization/RolePermissionRepository;)V", "authorize", "Lreactor/core/publisher/Mono;", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "request", "Lme/ahoo/cosec/api/context/request/Request;", "context", "Lme/ahoo/cosec/api/context/SecurityContext;", "verifyGlobalPolicies", "Lme/ahoo/cosec/authorization/VerifyContext;", "verifyPolicies", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "verifyPrincipalPolicies", "verifyRolePermissions", "rolePermissions", "Lme/ahoo/cosec/api/permission/RolePermission;", "verifyRoot", "Lme/ahoo/cosec/api/policy/VerifyResult;", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nSimpleAuthorization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1855#2:216\n766#2:217\n857#2,2:218\n1864#2,3:220\n1856#2:223\n1855#2:224\n766#2:225\n857#2,2:226\n1864#2,3:228\n1856#2:231\n1855#2:232\n766#2:233\n857#2,2:234\n1855#2,2:236\n1856#2:238\n1855#2:239\n766#2:240\n857#2,2:241\n1855#2,2:243\n1856#2:245\n*S KotlinDebug\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n*L\n50#1:216\n51#1:217\n51#1:218,2\n53#1:220,3\n50#1:223\n71#1:224\n72#1:225\n72#1:226,2\n74#1:228,3\n71#1:231\n102#1:232\n103#1:233\n103#1:234,2\n105#1:236,2\n102#1:238\n122#1:239\n123#1:240\n123#1:241,2\n125#1:243,2\n122#1:245\n*E\n"})
public final class SimpleAuthorization
implements Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PolicyRepository policyRepository;
    @NotNull
    private final RolePermissionRepository rolePermissionRepository;
    private static final Logger log = LoggerFactory.getLogger(SimpleAuthorization.class);

    public SimpleAuthorization(@NotNull PolicyRepository policyRepository, @NotNull RolePermissionRepository rolePermissionRepository) {
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        Intrinsics.checkNotNullParameter((Object)rolePermissionRepository, (String)"rolePermissionRepository");
        this.policyRepository = policyRepository;
        this.rolePermissionRepository = rolePermissionRepository;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyContext verifyPolicies(List<? extends Policy> policies, Request request, SecurityContext context) {
        VerifyResult verifyResult;
        void statement;
        void $this$forEachIndexed$iv;
        int index$iv22;
        boolean $i$f$forEachIndexed;
        Object element$iv$iv2;
        Object destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        Policy policy;
        Iterable $this$forEach$iv = policies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Statement statement2 = (Statement)element$iv$iv2;
                boolean bl2 = false;
                if (!(statement2.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (Statement)item$iv;
                int index = n;
                boolean bl3 = false;
                verifyResult = statement.verify(request, context);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Explicit Deny].");
                }
                return new PolicyVerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        $this$forEach$iv = policies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            Iterable index$iv22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Statement statement3 = (Statement)element$iv$iv2;
                boolean bl4 = false;
                if (!(statement3.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (Statement)item$iv;
                int index = n;
                boolean bl5 = false;
                verifyResult = statement.verify(request, context);
                if (verifyResult != VerifyResult.ALLOW) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Allow].");
                }
                return new PolicyVerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyContext verifyRolePermissions(List<? extends RolePermission> rolePermissions, Request request, SecurityContext context) {
        VerifyResult verifyResult;
        void $this$forEach$iv;
        boolean $i$f$forEach;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        RolePermission rolePermission;
        Iterable $this$forEach$iv2 = rolePermissions;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            rolePermission = (RolePermission)element$iv;
            boolean bl = false;
            $this$filter$iv = rolePermission.getPermissions();
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                Permission permission = (Permission)element$iv$iv;
                boolean bl2 = false;
                if (!(permission.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$filterTo$iv$iv.next();
                Permission permission = (Permission)element$iv2;
                boolean bl3 = false;
                verifyResult = permission.verify(request, context);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Role[" + rolePermission.getId() + "] Permission[" + permission.getId() + "][" + permission.getName() + "] - [Explicit Deny].");
                }
                return new RoleVerifyContext(rolePermission.getId(), permission, verifyResult);
            }
        }
        $this$forEach$iv2 = rolePermissions;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            rolePermission = (RolePermission)element$iv;
            boolean bl = false;
            $this$filter$iv = rolePermission.getPermissions();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl3 = $this$filterTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                element$iv$iv = bl3.next();
                Statement statement = (Statement)element$iv$iv;
                boolean bl4 = false;
                if (!(statement.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Permission permission = (Permission)element$iv2;
                boolean bl5 = false;
                verifyResult = permission.verify(request, context);
                if (verifyResult != VerifyResult.ALLOW) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Role[" + rolePermission.getId() + "] Permission[" + permission.getId() + "][" + permission.getName() + "] - [Allow].");
                }
                return new RoleVerifyContext(rolePermission.getId(), permission, verifyResult);
            }
        }
        return null;
    }

    private final VerifyResult verifyRoot(SecurityContext context) {
        VerifyResult verifyResult;
        if (CoSecPrincipal.Companion.isRoot(context.getPrincipal())) {
            if (log.isDebugEnabled()) {
                log.debug("Verify [" + context + "] matched Root - [Allow].");
            }
            verifyResult = VerifyResult.ALLOW;
        } else {
            verifyResult = VerifyResult.IMPLICIT_DENY;
        }
        return verifyResult;
    }

    private final Mono<VerifyContext> verifyGlobalPolicies(Request request, SecurityContext context) {
        Mono mono = this.policyRepository.getGlobalPolicy().mapNotNull(arg_0 -> SimpleAuthorization.verifyGlobalPolicies$lambda$12((Function1)new Function1<List<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull List<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyGlobal\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyContext> verifyPrincipalPolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getPolicies().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
            return mono;
        }
        Mono mono = this.policyRepository.getPolicies(context.getPrincipal().getPolicies()).mapNotNull(arg_0 -> SimpleAuthorization.verifyPrincipalPolicies$lambda$13((Function1)new Function1<List<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull List<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyPrinci\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyContext> verifyRolePermissions(Request request, SecurityContext context) {
        if (context.getPrincipal().getRoles().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
            return mono;
        }
        Mono mono = this.rolePermissionRepository.getRolePermissions(request.getAppId(), context.getPrincipal().getRoles()).mapNotNull(arg_0 -> SimpleAuthorization.verifyRolePermissions$lambda$14((Function1)new Function1<List<? extends RolePermission>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(List<? extends RolePermission> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return SimpleAuthorization.access$verifyRolePermissions(this.this$0, it, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyRolePe\u2026text)\n            }\n    }");
        return mono;
    }

    @NotNull
    public Mono<AuthorizeResult> authorize(@NotNull Request request, @NotNull SecurityContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VerifyResult verifyResult = this.verifyRoot(context);
        if (verifyResult == VerifyResult.ALLOW) {
            return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getALLOW());
        }
        Mono mono = MonoExtensionsKt.switchIfEmpty((Mono)MonoExtensionsKt.switchIfEmpty(this.verifyGlobalPolicies(request, context), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyPrincipalPolicies(this.this$0, this.$request, this.$context);
            }
        })), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyRolePermissions(this.this$0, this.$request, this.$context);
            }
        })).map(arg_0 -> SimpleAuthorization.authorize$lambda$15((Function1)new Function1<VerifyContext, AuthorizeResult>(context){
            final /* synthetic */ SecurityContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final AuthorizeResult invoke(VerifyContext it) {
                AuthorizeResult authorizeResult;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                VerifyContext.Companion.setVerifyContext(this.$context, it);
                switch (authorize.WhenMappings.$EnumSwitchMapping$0[it.getResult().ordinal()]) {
                    case 1: {
                        authorizeResult = AuthorizeResult.Companion.getALLOW();
                        break;
                    }
                    case 2: {
                        authorizeResult = AuthorizeResult.Companion.getEXPLICIT_DENY();
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException("VerifyResult.IMPLICIT_DENY");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return authorizeResult;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun authorize(r\u2026ono()\n            }\n    }");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new Function0<Mono<AuthorizeResult>>(request, context){
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<AuthorizeResult> invoke() {
                if (SimpleAuthorization.access$getLog$cp().isDebugEnabled()) {
                    SimpleAuthorization.access$getLog$cp().debug("Verify [" + this.$request + "] [" + this.$context + "] No policies matched - [Implicit Deny].");
                }
                return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getIMPLICIT_DENY());
            }
        }));
    }

    private static final VerifyContext verifyGlobalPolicies$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyPrincipalPolicies$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyRolePermissions$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final AuthorizeResult authorize$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthorizeResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VerifyContext access$verifyPolicies(SimpleAuthorization $this, List policies, Request request, SecurityContext context) {
        return $this.verifyPolicies(policies, request, context);
    }

    public static final /* synthetic */ VerifyContext access$verifyRolePermissions(SimpleAuthorization $this, List rolePermissions, Request request, SecurityContext context) {
        return $this.verifyRolePermissions(rolePermissions, request, context);
    }

    public static final /* synthetic */ Mono access$verifyPrincipalPolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyPrincipalPolicies(request, context);
    }

    public static final /* synthetic */ Mono access$verifyRolePermissions(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyRolePermissions(request, context);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

