/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.policy.Effect;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.api.policy.Statement;
import me.ahoo.cosec.api.policy.VerifyResult;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import me.ahoo.cosec.authorization.VerifyContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization;", "Lme/ahoo/cosec/api/authorization/Authorization;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "(Lme/ahoo/cosec/authorization/PolicyRepository;)V", "authorize", "Lreactor/core/publisher/Mono;", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "request", "Lme/ahoo/cosec/api/context/request/Request;", "context", "Lme/ahoo/cosec/api/context/SecurityContext;", "verifyGlobalPolicies", "Lme/ahoo/cosec/authorization/VerifyContext;", "verifyPolicies", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "verifyPrincipalPolicies", "verifyRolePolicies", "verifyRoot", "Lme/ahoo/cosec/api/policy/VerifyResult;", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nSimpleAuthorization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2:157\n766#2:158\n857#2,2:159\n1864#2,3:161\n1856#2:164\n1855#2:165\n766#2:166\n857#2,2:167\n1864#2,3:169\n1856#2:172\n*S KotlinDebug\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n*L\n41#1:157\n42#1:158\n42#1:159,2\n44#1:161,3\n41#1:164\n62#1:165\n63#1:166\n63#1:167,2\n65#1:169,3\n62#1:172\n*E\n"})
public final class SimpleAuthorization
implements Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PolicyRepository policyRepository;
    private static final Logger log = LoggerFactory.getLogger(SimpleAuthorization.class);

    public SimpleAuthorization(@NotNull PolicyRepository policyRepository) {
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        this.policyRepository = policyRepository;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyContext verifyPolicies(Set<? extends Policy> policies, Request request, SecurityContext context) {
        VerifyResult verifyResult;
        void statement;
        void $this$forEachIndexed$iv;
        int index$iv22;
        boolean $i$f$forEachIndexed;
        Object element$iv$iv2;
        Object destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        Policy policy;
        Iterable $this$forEach$iv = policies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Statement statement2 = (Statement)element$iv$iv2;
                boolean bl2 = false;
                if (!(statement2.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (Statement)item$iv;
                int index = n;
                boolean bl3 = false;
                verifyResult = statement.verify(request, context);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Explicit Deny].");
                }
                return new VerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        $this$forEach$iv = policies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            $i$f$filter = false;
            Iterable index$iv22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Statement statement3 = (Statement)element$iv$iv2;
                boolean bl4 = false;
                if (!(statement3.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (Statement)item$iv;
                int index = n;
                boolean bl5 = false;
                verifyResult = statement.verify(request, context);
                if (verifyResult != VerifyResult.ALLOW) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Allow].");
                }
                return new VerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        return null;
    }

    private final VerifyResult verifyRoot(SecurityContext context) {
        VerifyResult verifyResult;
        if (CoSecPrincipal.Companion.isRoot(context.getPrincipal())) {
            if (log.isDebugEnabled()) {
                log.debug("Verify [" + context + "] matched Root - [Allow].");
            }
            verifyResult = VerifyResult.ALLOW;
        } else {
            verifyResult = VerifyResult.IMPLICIT_DENY;
        }
        return verifyResult;
    }

    private final Mono<VerifyContext> verifyGlobalPolicies(Request request, SecurityContext context) {
        Mono mono = this.policyRepository.getGlobalPolicy().mapNotNull(arg_0 -> SimpleAuthorization.verifyGlobalPolicies$lambda$6((Function1)new Function1<Set<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyGlobal\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyContext> verifyPrincipalPolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getPolicies().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
            return mono;
        }
        Mono mono = this.policyRepository.getPolicies(context.getPrincipal().getPolicies()).mapNotNull(arg_0 -> SimpleAuthorization.verifyPrincipalPolicies$lambda$7((Function1)new Function1<Set<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyPrinci\u2026text)\n            }\n    }");
        return mono;
    }

    private final Mono<VerifyContext> verifyRolePolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getRoles().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
            return mono;
        }
        Mono mono = this.policyRepository.getRolePolicy(context.getPrincipal().getRoles()).mapNotNull(arg_0 -> SimpleAuthorization.verifyRolePolicies$lambda$8((Function1)new Function1<Set<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull Set<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun verifyRolePo\u2026text)\n            }\n    }");
        return mono;
    }

    @NotNull
    public Mono<AuthorizeResult> authorize(@NotNull Request request, @NotNull SecurityContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VerifyResult verifyResult = this.verifyRoot(context);
        if (verifyResult == VerifyResult.ALLOW) {
            return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getALLOW());
        }
        Mono mono = MonoExtensionsKt.switchIfEmpty((Mono)MonoExtensionsKt.switchIfEmpty(this.verifyGlobalPolicies(request, context), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyPrincipalPolicies(this.this$0, this.$request, this.$context);
            }
        })), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyRolePolicies(this.this$0, this.$request, this.$context);
            }
        })).map(arg_0 -> SimpleAuthorization.authorize$lambda$9((Function1)new Function1<VerifyContext, AuthorizeResult>(context){
            final /* synthetic */ SecurityContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final AuthorizeResult invoke(VerifyContext it) {
                AuthorizeResult authorizeResult;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                VerifyContext.Companion.setVerifyContext(this.$context, it);
                switch (authorize.WhenMappings.$EnumSwitchMapping$0[it.getResult().ordinal()]) {
                    case 1: {
                        authorizeResult = AuthorizeResult.Companion.getALLOW();
                        break;
                    }
                    case 2: {
                        authorizeResult = AuthorizeResult.Companion.getEXPLICIT_DENY();
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException("VerifyResult.IMPLICIT_DENY");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return authorizeResult;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun authorize(r\u2026ono()\n            }\n    }");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new Function0<Mono<AuthorizeResult>>(request, context){
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<AuthorizeResult> invoke() {
                if (SimpleAuthorization.access$getLog$cp().isDebugEnabled()) {
                    SimpleAuthorization.access$getLog$cp().debug("Verify [" + this.$request + "] [" + this.$context + "] No policies matched - [Implicit Deny].");
                }
                return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getIMPLICIT_DENY());
            }
        }));
    }

    private static final VerifyContext verifyGlobalPolicies$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyPrincipalPolicies$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyRolePolicies$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final AuthorizeResult authorize$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthorizeResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VerifyContext access$verifyPolicies(SimpleAuthorization $this, Set policies, Request request, SecurityContext context) {
        return $this.verifyPolicies(policies, request, context);
    }

    public static final /* synthetic */ Mono access$verifyPrincipalPolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyPrincipalPolicies(request, context);
    }

    public static final /* synthetic */ Mono access$verifyRolePolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyRolePolicies(request, context);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

