/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.policy.ActionMatcher;
import me.ahoo.cosec.policy.ActionPatternReplacer;
import me.ahoo.cosec.policy.AllActionMatcher;
import me.ahoo.cosec.policy.NoneActionMatcher;
import me.ahoo.cosec.policy.PathActionMatcher;
import me.ahoo.cosec.policy.RegularActionMatcher;
import me.ahoo.cosec.policy.ReplaceablePathActionMatcher;
import me.ahoo.cosec.policy.ReplaceableRegularActionMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lme/ahoo/cosec/policy/ActionMatcherFactory;", "", "()V", "create", "Lme/ahoo/cosec/policy/ActionMatcher;", "type", "", "pattern", "cosec-core"})
public final class ActionMatcherFactory {
    @NotNull
    public static final ActionMatcherFactory INSTANCE = new ActionMatcherFactory();

    private ActionMatcherFactory() {
    }

    @NotNull
    public final ActionMatcher create(@NotNull String type, @NotNull String pattern) {
        ActionMatcher actionMatcher;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = type.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        switch (string) {
            case "ALL": {
                actionMatcher = AllActionMatcher.INSTANCE;
                break;
            }
            case "NONE": {
                actionMatcher = NoneActionMatcher.INSTANCE;
                break;
            }
            case "PATH": {
                if (ActionPatternReplacer.INSTANCE.isTemplate(pattern)) {
                    actionMatcher = new ReplaceablePathActionMatcher(pattern);
                    break;
                }
                actionMatcher = new PathActionMatcher(pattern);
                break;
            }
            case "REG": {
                if (ActionPatternReplacer.INSTANCE.isTemplate(pattern)) {
                    actionMatcher = new ReplaceableRegularActionMatcher(pattern);
                    break;
                }
                actionMatcher = new RegularActionMatcher(pattern);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ActionMatcher type: " + type);
            }
        }
        return actionMatcher;
    }
}

