/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.context.SecurityContextKt;
import me.ahoo.cosec.principal.CoSecPrincipal;
import me.ahoo.cosec.principal.TenantPrincipal;
import me.ahoo.cosec.tenant.Tenant;
import me.ahoo.cosec.tenant.TenantCapable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0013\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\nR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lme/ahoo/cosec/context/SecurityContext;", "Lme/ahoo/cosec/tenant/TenantCapable;", "principal", "Lme/ahoo/cosec/principal/CoSecPrincipal;", "tenant", "Lme/ahoo/cosec/tenant/Tenant;", "(Lme/ahoo/cosec/principal/CoSecPrincipal;Lme/ahoo/cosec/tenant/Tenant;)V", "attributes", "", "", "", "getPrincipal", "()Lme/ahoo/cosec/principal/CoSecPrincipal;", "getTenant", "()Lme/ahoo/cosec/tenant/Tenant;", "getAttribute", "T", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "getRequiredAttribute", "setAttribute", "value", "Companion", "cosec-core"})
@ThreadSafe
public final class SecurityContext
implements TenantCapable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoSecPrincipal principal;
    @NotNull
    private final Tenant tenant;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    public static final String KEY = "COSEC_SECURITY_CONTEXT";
    @NotNull
    private static final SecurityContext ANONYMOUS = new SecurityContext(TenantPrincipal.ANONYMOUS, null, 2, null);

    public SecurityContext(@NotNull CoSecPrincipal principal, @NotNull Tenant tenant) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        this.principal = principal;
        this.tenant = tenant;
        this.attributes = new ConcurrentHashMap();
    }

    public /* synthetic */ SecurityContext(CoSecPrincipal coSecPrincipal, Tenant tenant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tenant = SecurityContextKt.getTenant(coSecPrincipal);
        }
        this(coSecPrincipal, tenant);
    }

    @NotNull
    public final CoSecPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    @NotNull
    public Tenant getTenant() {
        return this.tenant;
    }

    @NotNull
    public final SecurityContext setAttribute(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.attributes.put(key, value);
        return this;
    }

    @Nullable
    public final <T> T getAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (T)this.attributes.get(key);
    }

    public final <T> T getRequiredAttribute(@NotNull String key) {
        T value;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        T t = value = this.getAttribute(key);
        if (t == null) {
            boolean bl = false;
            String string = "The required attribute:" + key + " is not found.";
            throw new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/ahoo/cosec/context/SecurityContext$Companion;", "", "()V", "ANONYMOUS", "Lme/ahoo/cosec/context/SecurityContext;", "getANONYMOUS", "()Lme/ahoo/cosec/context/SecurityContext;", "KEY", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecurityContext getANONYMOUS() {
            return ANONYMOUS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

