/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.service;

import java.util.Iterator;
import java.util.List;
import ltd.fdsa.research.model.entity.FriendRelation;
import ltd.fdsa.research.model.entity.PersonNode;
import ltd.fdsa.research.repository.PersonNeo4jRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="neo4jServiceImpl")
public class Neo4jServiceImpl {
    @Autowired
    private PersonNeo4jRepository repository;

    public void saveFriendship(String fromName, String toName) {
        PersonNode from = this.repository.findByFirstName(fromName).get();
        PersonNode to = this.repository.findByFirstName(toName).get();
        FriendRelation FriendRelation2 = new FriendRelation();
        FriendRelation2.setFrom(from);
        FriendRelation2.setTo(to);
        from.addRelation(FriendRelation2);
        this.repository.save(from);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteFriendship(String fromName, String toName) {
        PersonNode fromPersonNode = this.repository.findByFirstName(fromName).get();
        List<FriendRelation> FriendRelationList = fromPersonNode.getFriendList();
        Iterator<FriendRelation> iterator = FriendRelationList.iterator();
        while (iterator.hasNext()) {
            FriendRelation relation = iterator.next();
            PersonNode fromNode = relation.getFrom();
            PersonNode toNode = relation.getTo();
            String fromNodeName = fromNode.getFirstName();
            String toNodeName = toNode.getFirstName();
            if (!fromNodeName.equals(fromName) || !toNodeName.equals(toName)) continue;
            iterator.remove();
        }
        this.repository.save(fromPersonNode);
    }
}

