/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.service;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.util.Strings;

public class FileRead
implements Closeable {
    private BufferedReader reader;
    private StringBuffer errors;
    private String[] headers;
    private Map<String, String> records;
    private int lineNumber;

    public FileRead(String path) {
        try {
            File file = new File(path);
            FileReader fileReader = new FileReader(file);
            this.reader = new BufferedReader(fileReader);
            this.errors = new StringBuffer();
            this.lineNumber = 0;
        }
        catch (FileNotFoundException e) {
            this.errors.append(e.getMessage() + "\r\n");
        }
    }

    public boolean readHeader() {
        if (this.lineNumber > 0) {
            return true;
        }
        try {
            String line = this.reader.readLine();
            ++this.lineNumber;
            if (Strings.isEmpty((CharSequence)line)) {
                return false;
            }
            this.headers = line.split(",");
            return true;
        }
        catch (IOException e) {
            this.errors.append(e.getMessage() + "\r\n");
            return false;
        }
    }

    public boolean readRecord() {
        this.records = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (this.lineNumber <= 0 && !this.readHeader()) {
            return false;
        }
        try {
            String[] items;
            String line = this.reader.readLine();
            ++this.lineNumber;
            if (Strings.isEmpty((CharSequence)line)) {
                return false;
            }
            int i = line.indexOf(34);
            if (i > 0) {
                try {
                    line = this.removeQuote(line, i);
                }
                catch (Exception ex) {
                    this.errors.append(line + "\r\n");
                    return true;
                }
            }
            if ((items = line.split(",")).length != this.headers.length) {
                this.errors.append("length error: " + this.lineNumber + ", " + line + "\r\n");
                return true;
            }
            for (i = 0; i < items.length; ++i) {
                this.records.put(this.headers[i], items[i]);
            }
            return true;
        }
        catch (IOException ex) {
            this.errors.append(ex.getMessage() + "\r\n");
            return false;
        }
    }

    private String removeQuote(String line, int i) {
        if (i > 0) {
            String left = line.substring(0, i);
            System.out.println(left);
            String right = line.substring(i + 1);
            System.out.println(right);
            String middle = right.substring(0, right.indexOf(34));
            middle = middle.replace(",", "$|$");
            System.out.println(middle);
            right = right.substring(right.indexOf(34) + 1);
            line = left + middle + right;
        }
        if ((i = line.indexOf(34)) > 0) {
            return this.removeQuote(line, i);
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public StringBuffer getErrors() {
        return this.errors;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Map<String, String> getRecords() {
        return this.records;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public void setErrors(StringBuffer errors) {
        this.errors = errors;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public void setRecords(Map<String, String> records) {
        this.records = records;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileRead)) {
            return false;
        }
        FileRead other = (FileRead)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        BufferedReader this$reader = this.getReader();
        BufferedReader other$reader = other.getReader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        StringBuffer this$errors = this.getErrors();
        StringBuffer other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHeaders(), other.getHeaders())) {
            return false;
        }
        Map<String, String> this$records = this.getRecords();
        Map<String, String> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileRead;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        BufferedReader $reader = this.getReader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        StringBuffer $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeaders());
        Map<String, String> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "FileRead(reader=" + this.getReader() + ", errors=" + this.getErrors() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ", records=" + this.getRecords() + ", lineNumber=" + this.getLineNumber() + ")";
    }
}

