/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.service;

import com.opencsv.CSVReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class CsvFileRead
implements Closeable {
    private CSVReader reader;
    private StringBuffer errors;
    private String[] headers;
    private Map<String, String> records;
    private int lineNumber;

    public CsvFileRead(String path) {
        try {
            File file = new File(path);
            FileReader fileReader = new FileReader(file);
            this.reader = new CSVReader((Reader)fileReader);
            this.errors = new StringBuffer();
            this.lineNumber = 0;
        }
        catch (FileNotFoundException e) {
            this.errors.append(e.getMessage() + "\r\n");
        }
    }

    public boolean readHeader() {
        if (this.lineNumber > 0) {
            return true;
        }
        try {
            String[] line = this.reader.readNext();
            ++this.lineNumber;
            if (line == null) {
                return false;
            }
            this.headers = line;
            return true;
        }
        catch (IOException e) {
            this.errors.append(e.getMessage() + "\r\n");
            return false;
        }
    }

    public boolean readRecord() {
        this.records = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (this.lineNumber <= 0 && !this.readHeader()) {
            return false;
        }
        try {
            CharSequence[] line = this.reader.readNext();
            ++this.lineNumber;
            if (line == null) {
                return false;
            }
            if (line.length != this.headers.length) {
                this.errors.append("length error: " + this.lineNumber + ", " + String.join((CharSequence)",", line) + "\r\n");
                return true;
            }
            for (int i = 0; i < line.length; ++i) {
                this.records.put(this.headers[i], (String)line[i]);
            }
            return true;
        }
        catch (IOException ex) {
            this.errors.append(ex.getMessage() + "\r\n");
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public CSVReader getReader() {
        return this.reader;
    }

    public StringBuffer getErrors() {
        return this.errors;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Map<String, String> getRecords() {
        return this.records;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setReader(CSVReader reader) {
        this.reader = reader;
    }

    public void setErrors(StringBuffer errors) {
        this.errors = errors;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public void setRecords(Map<String, String> records) {
        this.records = records;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvFileRead)) {
            return false;
        }
        CsvFileRead other = (CsvFileRead)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        CSVReader this$reader = this.getReader();
        CSVReader other$reader = other.getReader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        StringBuffer this$errors = this.getErrors();
        StringBuffer other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHeaders(), other.getHeaders())) {
            return false;
        }
        Map<String, String> this$records = this.getRecords();
        Map<String, String> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvFileRead;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        CSVReader $reader = this.getReader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        StringBuffer $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeaders());
        Map<String, String> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "CsvFileRead(reader=" + this.getReader() + ", errors=" + this.getErrors() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ", records=" + this.getRecords() + ", lineNumber=" + this.getLineNumber() + ")";
    }
}

