/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ltd.fdsa.research.algorithm.FastSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solution {
    private static final Logger log = LoggerFactory.getLogger(Solution.class);

    public int removeDuplicates(int[] nums) {
        if (nums.length == 0) {
            return 0;
        }
        int i = 0;
        for (int j = 1; j < nums.length; ++j) {
            if (nums[j] == nums[i]) continue;
            nums[++i] = nums[j];
        }
        return i + 1;
    }

    public int maxProfit(int[] prices) {
        int max = 0;
        int buy = 0;
        int oldPrice = prices[0];
        int newPrice = 0;
        for (int i = 1; i < prices.length; ++i) {
            newPrice = prices[i];
            if (oldPrice < newPrice) {
                if (buy == 0) {
                    buy = oldPrice;
                }
                max += newPrice - oldPrice;
            } else {
                buy = 0;
            }
            oldPrice = prices[i];
        }
        return max;
    }

    public void rotate(int[] nums, int k) {
        int i;
        int l = nums.length;
        int[] arrays = new int[l];
        for (i = 0; i < l; ++i) {
            arrays[i] = nums[(l - k + i) % l];
        }
        for (i = 0; i < l; ++i) {
            nums[i] = arrays[i];
        }
    }

    public void rotate2(int[] nums, int k) {
        this.reverse(nums, 0, nums.length - 1);
        this.reverse(nums, 0, (k %= nums.length) - 1);
        this.reverse(nums, k, nums.length - 1);
    }

    public void reverse(int[] nums, int start, int end) {
        while (start < end) {
            int temp = nums[start];
            nums[start] = nums[end];
            nums[end] = temp;
            ++start;
            --end;
        }
    }

    public boolean containsDuplicate(int[] nums) {
        HashSet<Integer> set = new HashSet<Integer>(nums.length);
        for (int i = 0; i < nums.length; ++i) {
            if (set.add(nums[i])) continue;
            return true;
        }
        return false;
    }

    public ListNode removeNthFromEnd(ListNode head, int n) {
        int len = 1;
        ListNode next = head.next;
        while (next != null) {
            ++len;
            next = next.next;
        }
        int x = len - n;
        if (x == 0) {
            return head.next;
        }
        if (x < 0) {
            return null;
        }
        next = head;
        for (int i = 0; i < x - 1; ++i) {
            next = next.next;
        }
        next.next = x + 1 >= len ? null : next.next.next;
        return head;
    }

    public int[] twoSum(int[] nums, int target) {
        for (int i = 0; i < nums.length - 1; ++i) {
            for (int j = i + 1; j < nums.length; ++j) {
                if (nums[i] + nums[j] != target) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    public ListNode addTwoNumbers(ListNode l1, ListNode l2) {
        ListNode node = null;
        int carry = 0;
        ListNode next = null;
        while (l1 != null || l2 != null || carry != 0) {
            int left = 0;
            if (l1 == null) {
                if (carry == 0) {
                    next.val = l2.val;
                    next.next = l2.next;
                    break;
                }
            } else {
                left = l1.val;
            }
            int right = 0;
            if (l2 == null) {
                if (carry == 0) {
                    next.val = l1.val;
                    next.next = l1.next;
                    break;
                }
            } else {
                right = l2.val;
            }
            int s = left + right + carry;
            if (node == null) {
                node = new ListNode(s % 10, null);
                carry = s / 10;
                l1 = l1 == null ? null : l1.next;
                ListNode listNode = l2 = l2 == null ? null : l2.next;
                if (l1 == null && l2 == null && carry == 0) break;
                next = node.next = new ListNode(0, null);
                continue;
            }
            if (next != null) {
                next.val = s % 10;
            }
            carry = s / 10;
            l1 = l1 == null ? null : l1.next;
            ListNode listNode = l2 = l2 == null ? null : l2.next;
            if (l1 == null && l2 == null && carry == 0) break;
            next = next.next = new ListNode(0, null);
        }
        return node;
    }

    public List<List<Integer>> threeSum(int[] nums) {
        ArrayList<List<Integer>> list = new ArrayList<List<Integer>>();
        if (nums.length < 3) {
            return list;
        }
        FastSort sort = new FastSort();
        sort.quickSort(nums, 0, nums.length - 1);
        log.info(Arrays.toString(nums));
        for (int index = 0; index < nums.length - 2; ++index) {
            if (nums[index] == nums[index + 1]) continue;
            int left = index + 1;
            int right = nums.length - 1;
            int sum = nums[index] + nums[left] + nums[right];
            while (left < right && sum != 0) {
                if (sum > 0) {
                    sum = nums[index] + nums[left] + nums[--right];
                    continue;
                }
                if (sum >= 0) continue;
                sum = nums[index] + nums[++left] + nums[right];
            }
            if (sum != 0) continue;
            ArrayList<Integer> l = new ArrayList<Integer>();
            l.add(nums[index]);
            l.add(nums[left]);
            l.add(nums[right]);
            list.add(l);
        }
        return list;
    }

    public static class ListNode {
        public int val;
        public ListNode next;

        ListNode() {
        }

        ListNode(int val) {
            this.val = val;
        }

        public ListNode(int val, ListNode next) {
            this.val = val;
            this.next = next;
        }

        public String toString() {
            ArrayList<String> sb = new ArrayList<String>();
            sb.add(this.val + "");
            ListNode next = this.next;
            while (next != null) {
                sb.add(next.val + "");
                next = next.next;
            }
            return "[" + String.join((CharSequence)",", sb) + "]";
        }
    }
}

