/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.algorithm;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DijkstraAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(DijkstraAlgorithm.class);
    Map<String, Integer> graph = new HashMap<String, Integer>();
    Map<String, Integer> costs = new HashMap<String, Integer>();
    Map<String, String> path = new HashMap<String, String>();
    Map<String, Boolean> processed = new HashMap<String, Boolean>();

    public void demo(String[] args) {
        this.graph.put("s-a", 6);
        this.graph.put("s-b", 2);
        this.graph.put("a-t", 1);
        this.graph.put("b-a", 3);
        this.graph.put("b-t", 5);
        this.costs.put("a", 6);
        this.costs.put("b", 2);
        this.costs.put("t", 999);
        this.path.put("a", "s");
        this.path.put("b", "s");
        this.path.put("t", "");
        this.do_computer();
    }

    void do_computer() {
        Object cost;
        Map.Entry<String, Integer> node = this.find_lowest_cost_node();
        while (node != null) {
            cost = this.costs.get(node.getKey());
            HashMap<String, Integer> neighbors = this.get_neighbors(node.getKey());
            for (Map.Entry<String, Integer> entry : neighbors.entrySet()) {
                Integer costNew = (Integer)cost + entry.getValue();
                if (this.costs.get(entry.getKey()) <= costNew) continue;
                this.costs.put(entry.getKey(), costNew);
                this.path.put(entry.getKey(), node.getKey());
            }
            this.processed.put(node.getKey(), true);
            node = this.find_lowest_cost_node();
        }
        log.info("Costs:");
        cost = this.costs.keySet().iterator();
        while (cost.hasNext()) {
            String name;
            String key = name = (String)cost.next();
            String value = this.costs.get(name).toString();
            log.info(key + " " + value);
        }
        log.info("Path:");
        String pathString = this.path.get("t");
        String printString = "t";
        while (!StringUtils.isEmpty((Object)pathString)) {
            printString = pathString + " > " + printString;
            pathString = this.path.get(pathString);
        }
        log.info(printString);
    }

    Map.Entry<String, Integer> find_lowest_cost_node() {
        Integer lowestCost = Integer.MAX_VALUE;
        Map.Entry<String, Integer> result = null;
        for (Map.Entry<String, Integer> entry : this.costs.entrySet()) {
            String key = entry.getKey();
            if (this.processed.containsKey(key) || entry.getValue() >= lowestCost) continue;
            lowestCost = entry.getValue();
            result = entry;
        }
        return result;
    }

    HashMap<String, Integer> get_neighbors(String start) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.graph.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(start)) continue;
            list.put(entry.getKey().replace(start + "-", ""), entry.getValue());
        }
        return list;
    }
}

