/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.algorithm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitMap {
    private static final Logger log = LoggerFactory.getLogger(BitMap.class);
    private int[] bitmap = new int[1];
    private int bit = 32;

    public boolean set(int number) {
        int index = number / this.bit;
        int position = number % this.bit;
        if (index > this.bitmap.length) {
            int[] newOne = new int[index];
            for (int i = 0; i < this.bitmap.length; ++i) {
                newOne[i] = this.bitmap[i];
            }
            this.bitmap = newOne;
        }
        if (this.contains(index, position)) {
            return false;
        }
        int n = index;
        this.bitmap[n] = this.bitmap[n] | 1 << this.bit - 1 - position;
        return true;
    }

    public boolean containsDuplicate(int[] nums) {
        for (int i = 0; i < nums.length; ++i) {
            if (this.set(nums[i])) continue;
            return true;
        }
        return false;
    }

    private boolean contains(int index, int position) {
        return (this.bitmap[index] & 1 << this.bit - 1 - position) != 0;
    }
}

