/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.research.algorithm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BFS {
    private static final Logger log = LoggerFactory.getLogger(BFS.class);
    Map<String, String[]> graph = new HashMap<String, String[]>();
    Queue<String> queue = new LinkedList<String>();
    Map<String, Boolean> processed = new HashMap<String, Boolean>();

    public void demo(String[] args) {
        this.graph.put("I", new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7"});
        this.graph.put("F1", new String[]{"F1", "F12", "F3", "F7", "F8"});
        this.graph.put("F2", new String[]{"F11", "F12", "F3", "F4", "F5"});
        this.graph.put("F3", new String[]{"F1", "F12", "F3", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F4", new String[]{"F1", "F22", "F3", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F5", new String[]{"F3", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F6", new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F7", new String[]{"F1", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F8", new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8"});
        this.graph.put("F11", new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8"});
        this.queue.offer("I");
        String result = this.do_computer();
        log.info("result: " + result);
    }

    String do_computer() {
        int level = 0;
        String person = this.queue.poll();
        while (!StringUtils.isEmpty((Object)person)) {
            ++level;
            if (this.is_satisfied(person).booleanValue()) {
                return String.format("get satisfied person:%s,at level:%d", person, level);
            }
            if (!this.processed.containsKey(person)) {
                this.processed.put(person, true);
                if (this.graph.containsKey(person)) {
                    for (String friend : this.graph.get(person)) {
                        this.queue.offer(friend);
                    }
                }
            }
            person = this.queue.poll();
        }
        return "Not Found";
    }

    Boolean is_satisfied(String person) {
        return person.endsWith("8");
    }
}

