/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.audit.annotation;

import java.lang.reflect.Method;
import ltd.fdsa.audit.action.base.BaseActionMap;
import ltd.fdsa.audit.annotation.ActionLog;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
public class ActionLogAop {
    private static final Logger log = LoggerFactory.getLogger(ActionLogAop.class);
    private static final String DEFAULT_ACTION_NAME = "default";

    @Pointcut(value="@annotation(ActionLog)")
    public void actionLog() {
    }

    @Around(value="actionLog()")
    public Object recordLog(ProceedingJoinPoint point) throws Throwable {
        Object proceed = point.proceed();
        Method targetMethod = ((MethodSignature)point.getSignature()).getMethod();
        ActionLog anno = targetMethod.getAnnotation(ActionLog.class);
        String name = anno.name();
        String message = anno.message();
        String key = anno.key();
        Class<? extends BaseActionMap> action = anno.action();
        BaseActionMap instance = action.newInstance();
        Object actionModel = instance.get(!key.isEmpty() ? key : DEFAULT_ACTION_NAME);
        Assert.notNull((Object)actionModel, (String)("\u65e0\u6cd5\u83b7\u53d6\u65e5\u5fd7\u7684\u884c\u4e3a\u65b9\u6cd5\uff0c\u8bf7\u68c0\u67e5\uff1a" + point.getSignature()));
        return proceed;
    }
}

