/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.plus.service;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import ltd.fdsa.database.entity.BaseEntity;
import ltd.fdsa.database.entity.Status;
import ltd.fdsa.database.mybatis.plus.mapper.reader.ReadMapper;
import ltd.fdsa.database.mybatis.plus.mapper.writer.WriteMapper;
import ltd.fdsa.database.service.DataAccessService;
import ltd.fdsa.database.sql.conditions.Condition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MybatisPlusService<Entity extends BaseEntity<ID>, ID, Writer extends WriteMapper<Entity>, Reader extends ReadMapper<Entity>>
implements DataAccessService<Entity, ID> {
    @Autowired
    protected Writer writer;
    @Autowired
    protected Reader reader;

    public Optional<Entity> findById(ID id) {
        return Optional.of(this.reader.selectById((Serializable)((Object)id.toString())));
    }

    public List<Entity> findAll() {
        return this.reader.selectList(null);
    }

    public List<Entity> findAllById(ID ... ids) {
        return null;
    }

    public long count() {
        return this.reader.selectCount(null).intValue();
    }

    public Page<Entity> findAll(Pageable pageable) {
        return null;
    }

    public boolean existsById(ID id) {
        return this.reader.selectById((Serializable)((Object)id.toString())) != null;
    }

    public List<Entity> find(Condition where) {
        return Collections.emptyList();
    }

    public Entity update(Entity entity) {
        this.updateFill(entity);
        this.writer.updateById(entity);
        return entity;
    }

    void insertFill(Entity entity) {
        entity.setCreateTime(LocalDateTime.now());
        entity.setUpdateTime(LocalDateTime.now());
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String userId = request.getHeader("X_USER_ID");
        entity.setCreateBy((Object)userId);
        entity.setUpdateBy((Object)userId);
    }

    void updateFill(Entity entity) {
        entity.setUpdateTime(LocalDateTime.now());
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String userId = request.getHeader("X_USER_ID");
        entity.setUpdateBy((Object)userId);
    }

    public void updateAll(Entity ... entities) {
        for (Entity entity : entities) {
            this.updateFill(entity);
            this.writer.updateById(entity);
        }
    }

    public void deleteById(ID id) {
        BaseEntity entity = (BaseEntity)this.writer.selectById((Serializable)((Object)id.toString()));
        if (entity != null && entity.getStatus() != Status.DELETE) {
            this.deleteAll(new BaseEntity[]{entity});
        }
    }

    public void deleteAll(Entity ... entities) {
        for (Entity entity : entities) {
            entity.setStatus(Status.DELETE);
            this.updateFill(entity);
            this.writer.updateById(entity);
        }
    }

    public void clearAll() {
        this.writer.delete(null);
    }

    public Entity insert(Entity entity) {
        this.insertFill(entity);
        this.writer.insert(entity);
        return entity;
    }

    public void insertAll(Entity ... entities) {
        for (Entity entity : entities) {
            this.insertFill(entity);
            this.writer.insert(entity);
        }
    }
}

