/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.plus.interceptor;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.google.common.base.Strings;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AutoUpdateHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoUpdateHandler.class);

    public void insertFill(MetaObject metaObject) {
        this.setFieldValByName("createTime", LocalDateTime.now(), metaObject);
        this.setFieldValByName("updateTime", LocalDateTime.now(), metaObject);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String userId = request.getHeader("X_USER_ID");
        if (Strings.isNullOrEmpty((String)userId)) {
            this.setFieldValByName("updateBy", -1, metaObject);
            this.setFieldValByName("createBy", -1, metaObject);
        } else {
            this.setFieldValByName("updateBy", userId, metaObject);
            this.setFieldValByName("createBy", userId, metaObject);
        }
    }

    public void updateFill(MetaObject metaObject) {
        this.setFieldValByName("updateTime", LocalDateTime.now(), metaObject);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String userId = request.getHeader("X_USER_ID");
        if (Strings.isNullOrEmpty((String)userId)) {
            this.setFieldValByName("updateBy", -1, metaObject);
        } else {
            this.setFieldValByName("updateBy", userId, metaObject);
        }
    }
}

