/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);

    public Set<Class<?>> getClasses(String packageName) throws Exception {
        HashSet classes = new HashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.addClass(classes, filePath, packageName);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Exception", (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Exception", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Exception", (Throwable)e);
        }
        return classes;
    }

    public void addClass(Set<Class<?>> classes, String filePath, String packageName) throws Exception {
        File[] files = new File(filePath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory());
        assert (files != null);
        for (File file2 : files) {
            String fileName = file2.getName();
            if (!file2.isFile()) continue;
            String classsName = fileName.substring(0, fileName.lastIndexOf("."));
            if (!packageName.isEmpty()) {
                classsName = packageName + "." + classsName;
            }
            this.doAddClass(classes, classsName);
        }
    }

    public void doAddClass(Set<Class<?>> classes, String classsName) throws Exception {
        ClassLoader classLoader = new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return super.loadClass(name);
            }
        };
        classes.add(classLoader.loadClass(classsName));
    }

    public <A extends Annotation> Set<Class<?>> getAnnotationClasses(String packageName, Class<A> annotationClass) throws Exception {
        HashSet controllers = new HashSet();
        Set<Class<?>> clsList = this.getClasses(packageName);
        if (clsList != null && clsList.size() > 0) {
            for (Class<?> cls : clsList) {
                if (cls.getAnnotation(annotationClass) == null) continue;
                controllers.add(cls);
            }
        }
        return controllers;
    }
}

