/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import ltd.fdsa.core.util.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static volatile PluginManager mgr;
    final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, PluginClassLoader> classLoaderCache = new HashMap<String, PluginClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluginManager getDefaultInstance() {
        if (mgr != null) return mgr;
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            if (mgr != null) return mgr;
            mgr = new PluginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mgr;
        }
    }

    private Class<?> loadPluginClass(String className) {
        PluginClassLoader classLoader = this.classLoaderCache.get(className);
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public PluginClassLoader getClassLoader(String className) {
        return this.classLoaderCache.get(className);
    }

    public <T> T getInstance(String className, Class<T> required) {
        Class<?> cls = this.loadPluginClass(className);
        if (required.isAssignableFrom(cls)) {
            try {
                return (T)cls.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can not newInstance class:" + className, e);
            }
        }
        throw new IllegalArgumentException("class:" + className + " not sub class of " + required);
    }

    public <T> T getInstance(String className, Class<T> required, Object ... objects) {
        Class<?> cls = this.loadPluginClass(className);
        try {
            Constructor<?>[] constructorArray;
            int n;
            int n2;
            if (required.isAssignableFrom(cls) && (n2 = 0) < (n = (constructorArray = cls.getConstructors()).length)) {
                Constructor<?> constructor = constructorArray[n2];
                return (T)constructor.newInstance(objects);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("class:" + className + " not sub class of " + required);
    }

    public synchronized void scan(String pluginPath) {
        if (Strings.isNullOrEmpty((String)pluginPath)) {
            throw new IllegalArgumentException("basePath can not be empty!");
        }
        File directory = new File(pluginPath);
        if (!directory.exists()) {
            throw new IllegalArgumentException("basePath not exists:" + pluginPath);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("basePath must be a directory:" + pluginPath);
        }
        for (String dir : directory.list()) {
            File pluginFile = new File(dir + "/plugins.json");
            if (!pluginFile.exists()) continue;
            PluginClassLoader classLoader = new PluginClassLoader(dir);
            try {
                for (JsonNode pluginInfo : this.mapper.readTree(pluginFile)) {
                    this.classLoaderCache.put(pluginInfo.get("className").asText(), classLoader);
                }
            }
            catch (IOException e) {
                log.error("file miss", (Throwable)e);
            }
        }
    }
}

