/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);

    public PluginClassLoader(String ... paths) {
        this(PluginClassLoader.getURLs(paths), PluginClassLoader.class.getClassLoader());
    }

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    private static URL[] getURLs(String[] paths) {
        Assert.isNull((Object)(null != paths && 0 != paths.length ? 1 : 0), (String)"jar\u5305\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a.");
        ArrayList<String> dirs = new ArrayList<String>();
        for (String path : paths) {
            dirs.add(path);
            PluginClassLoader.collectDirs(path, dirs);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : dirs) {
            urls.addAll(PluginClassLoader.doGetURLs(path));
        }
        return urls.toArray(new URL[0]);
    }

    private static void collectDirs(String path, List<String> collector) {
        if (null == path || Strings.isBlank((String)path)) {
            return;
        }
        File current = new File(path);
        if (!current.exists() || !current.isDirectory()) {
            return;
        }
        for (File child : current.listFiles()) {
            if (!child.isDirectory()) continue;
            collector.add(child.getAbsolutePath());
            PluginClassLoader.collectDirs(child.getAbsolutePath(), collector);
        }
    }

    private static List<URL> doGetURLs(String path) {
        Assert.isTrue((!Strings.isBlank((String)path) ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a.");
        File jarPath = new File(path);
        Assert.isTrue((jarPath.exists() && jarPath.isDirectory() ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u5fc5\u987b\u5b58\u5728\u4e14\u4e3a\u76ee\u5f55.");
        FileFilter jarFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        };
        File[] allJars = new File(path).listFiles(jarFilter);
        ArrayList<URL> jarURLs = new ArrayList<URL>(allJars.length);
        for (int i = 0; i < allJars.length; ++i) {
            try {
                jarURLs.add(allJars[i].toURI().toURL());
                continue;
            }
            catch (Exception e) {
                log.error("\u7cfb\u7edf\u52a0\u8f7djar\u5305\u51fa\u9519", (Throwable)e);
            }
        }
        return jarURLs;
    }
}

