/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class NamingUtils {
    private static final Logger log = LoggerFactory.getLogger(NamingUtils.class);
    private static final String UNDERLINE = "_";
    private static final String HAT = "^";
    private static final Pattern linePattern = Pattern.compile("_(\\w)");
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String underlineToCamel(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        name = name.toLowerCase();
        Matcher matcher = linePattern.matcher(name);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String removePrefix(String name, String ... prefix) {
        if (Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        if (null != prefix) {
            return Arrays.stream(prefix).filter(pf -> name.toLowerCase().matches(HAT + pf.toLowerCase() + ".*")).findFirst().map(pf -> name.substring(pf.length())).orElse(name);
        }
        return name;
    }

    public static String camelToUnderline(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        Matcher matcher = humpPattern.matcher(name);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, UNDERLINE + matcher.group(0));
        }
        matcher.appendTail(sb);
        return sb.toString().toLowerCase();
    }

    public static void formatLog(Logger log, String content, Object ... args) {
        int length = (content = MessageFormatter.arrayFormat((String)content, (Object[])args).getMessage()).length();
        if (length > 60) {
            log.info(NamingUtils.build(64, '='));
            log.info(content);
            log.info(NamingUtils.build(64, '='));
            return;
        }
        if ((length = 64 - length) % 2 > 0) {
            log.info("{}{}{}", new Object[]{NamingUtils.build(length /= 2, '='), content, NamingUtils.build(length + 1, '=')});
        } else {
            log.info("{}{}{}", new Object[]{NamingUtils.build(length /= 2, '='), content, NamingUtils.build(length, '=')});
        }
    }

    public static String format(String content, Object ... args) {
        return MessageFormatter.arrayFormat((String)content, (Object[])args).getMessage();
    }

    private static String build(int count, char c) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }
}

