/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressUtil {
    private static final Logger log = LoggerFactory.getLogger(IpAddressUtil.class);
    private static final String ANY_HOST_VALUE = "0.0.0.0";
    private static final String LOCAL_HOST_VALUE = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;

    private static InetAddress toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (IpAddressUtil.isPreferIPV6Address()) {
                return IpAddressUtil.normalizeV6Address(v6Address);
            }
        }
        if (IpAddressUtil.isValidV4Address(address)) {
            return address;
        }
        return null;
    }

    private static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    private static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        boolean result = name != null && IP_PATTERN.matcher(name).matches() && !ANY_HOST_VALUE.equals(name) && !LOCAL_HOST_VALUE.equals(name);
        return result;
    }

    private static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            InetAddress addressItem = IpAddressUtil.toValidAddress(localAddress);
            if (addressItem != null) {
                return addressItem;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    if (network.isLoopback() || network.isVirtual() || !network.isUp()) continue;
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            InetAddress addressItem = IpAddressUtil.toValidAddress(addresses.nextElement());
                            if (addressItem == null) continue;
                            try {
                                if (!addressItem.isReachable(100)) continue;
                                return addressItem;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                        }
                    }
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return localAddress;
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = IpAddressUtil.getLocalAddress0();
        return localAddress;
    }

    public static String getIp() {
        return IpAddressUtil.getLocalAddress().getHostAddress();
    }

    public static String getIpPort(int port) {
        String ip = IpAddressUtil.getIp();
        return IpAddressUtil.getIpPort(ip, port);
    }

    public static String getIpPort(String ip, int port) {
        if (ip == null) {
            return null;
        }
        return ip.concat(":").concat(String.valueOf(port));
    }

    public static Object[] parseIpPort(String address) {
        String[] array = address.split(":");
        String host = array[0];
        int port = Integer.parseInt(array[1]);
        return new Object[]{host, port};
    }
}

