/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String ENCODING = "UTF-8";

    public static boolean checkFileExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static String readFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFile(file);
    }

    public static String readFile(File file) {
        if (file == null) {
            return null;
        }
        Long fileLength = file.length();
        byte[] fileContent = new byte[fileLength.intValue()];
        try (FileInputStream in = new FileInputStream(file);){
            in.read(fileContent);
        }
        catch (FileNotFoundException e) {
            log.error("FileUtils.readFile", (Throwable)e);
        }
        catch (IOException e) {
            log.error("FileUtils.readFile", (Throwable)e);
        }
        try {
            return new String(fileContent, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String filePath, String content) {
        OutputStreamWriter fw = null;
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
                fw = new FileWriter(file);
            } else {
                fw = new FileWriter(file, false);
            }
        }
        catch (IOException e) {
            log.error("FileUtils.writeFile", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    log.error("FileUtils.writeFile", (Throwable)e);
                }
            }
        }
        try (PrintWriter pw = new PrintWriter(fw);){
            pw.print(content);
            pw.flush();
        }
        catch (Exception e) {
            log.error("FileUtils.writeFile", (Throwable)e);
        }
    }
}

