/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.service;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import ltd.fdsa.core.util.NamingUtils;

public class ServiceInfo {
    private String schema = "http";
    private String ip = "";
    private int port;
    private String name;
    private String id;
    private Map<String, String> metadata;

    public String getUrl() {
        return NamingUtils.format("{}://{}:{}", this.schema, this.ip, this.port);
    }

    public ServiceInfo() {
    }

    ServiceInfo(String schema, String ip, int port, String name, String id, Map<String, String> metadata) {
        this.schema = schema;
        this.ip = ip;
        this.port = port;
        this.name = name;
        this.id = id;
        this.metadata = metadata;
    }

    public static ServiceInfoBuilder builder() {
        return new ServiceInfoBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo other = (ServiceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceInfo(schema=" + this.getSchema() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", name=" + this.getName() + ", id=" + this.getId() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class ServiceInfoBuilder {
        private String schema;
        private String ip;
        private int port;
        private String name;
        private String id;
        private Map<String, String> metadata;

        ServiceInfoBuilder() {
        }

        public ServiceInfoBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ServiceInfoBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public ServiceInfoBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ServiceInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServiceInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ServiceInfoBuilder metadata(Map<String, String> metadata) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, String>();
            }
            this.metadata.putAll(metadata);
            return this;
        }

        public ServiceInfoBuilder withMetadata(String key, String data) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, String>();
            }
            this.metadata.put(key, data);
            return this;
        }

        public ServiceInfo build() {
            if (Strings.isNullOrEmpty((String)this.id)) {
                this.id = NamingUtils.format("{}:{}/{}", this.ip, this.port, this.name);
            }
            return new ServiceInfo(this.schema, this.ip, this.port, this.name, this.id, this.metadata);
        }
    }
}

