/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import ltd.fdsa.core.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializer.class);
    private static final ThreadLocal<Kryo> kryoLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String serialize(Object obj) {
        Kryo kryo = kryoLocal.get();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Output output = new Output((OutputStream)outputStream);
            kryo.writeObject(output, obj);
            output.close();
            String result = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            log.info("serialize:{}", (Object)result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            log.error("serialize failed:", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(String data, Class<T> clazz) {
        log.info("deserialize:{}", (Object)data);
        Kryo kryo = kryoLocal.get();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            Input input = new Input((InputStream)inputStream);
            Object result = kryo.readObject(input, clazz);
            input.close();
            Object object = result;
            return (T)object;
        }
        catch (IOException e) {
            log.error("deserialize failed:", (Throwable)e);
            return null;
        }
    }
}

