/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import ltd.fdsa.core.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String serialize(Object obj) {
        try {
            String result = mapper.writeValueAsString(obj);
            log.info("serialize:{}", (Object)result);
            return result;
        }
        catch (IOException e) {
            log.error("serialize failed:", (Throwable)e);
            return "";
        }
    }

    @Override
    public <T> T deserialize(String data, Class<T> clazz) {
        log.info("deserialize:{}", (Object)data);
        try {
            return (T)mapper.readValue(data.getBytes(StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            log.error("deserialize failed:", (Throwable)e);
            return null;
        }
    }
}

