/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.serializer;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import ltd.fdsa.core.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HessianSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(HessianSerializer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String serialize(Object obj) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Hessian2Output output = new Hessian2Output((OutputStream)outputStream);
            output.writeObject(obj);
            output.close();
            String result = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            log.info("serialize:{}", (Object)result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            log.error("serialize failed:", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(String data, Class<T> clazz) {
        log.info("deserialize:{}", (Object)data);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            Hessian2Input input = new Hessian2Input((InputStream)new BufferedInputStream(inputStream));
            Object result = input.readObject();
            input.close();
            Object object = result;
            return (T)object;
        }
        catch (IOException e) {
            log.error("deserialize failed:", (Throwable)e);
            return null;
        }
    }
}

