/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.refresh;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import ltd.fdsa.core.event.RefreshedEvent;
import ltd.fdsa.core.refresh.RefreshScopeRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class RefreshOperation {
    BeanDefinitionRegistry beanDefinitionRegistry;
    private ConcurrentHashMap map = new ConcurrentHashMap();
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        RefreshScopeRegistry refreshScopeRegistry = (RefreshScopeRegistry)this.applicationContext.getBean("configRefresh");
        this.beanDefinitionRegistry = refreshScopeRegistry.getBeanDefinitionRegistry();
        MutablePropertySources mutablePropertySources = this.applicationContext.getEnvironment().getPropertySources();
        OriginTrackedMapPropertySource originTrackedMapPropertySource = new OriginTrackedMapPropertySource("configRefresh", (Map)this.map);
        mutablePropertySources.addFirst((PropertySource)originTrackedMapPropertySource);
    }

    public void refresh() {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanDefinitionRegistry.getBeanDefinition(beanDefinitionName);
            if (!"configRefresh".equalsIgnoreCase(beanDefinition.getScope())) continue;
            this.applicationContext.getBeanFactory().destroyScopedBean(beanDefinitionName);
            this.applicationContext.getBean(beanDefinitionName);
        }
    }

    public void update(String key, String value) {
        MutablePropertySources mutablePropertySources = this.applicationContext.getEnvironment().getPropertySources();
        PropertySource propertySource = mutablePropertySources.get("configRefresh");
        ConcurrentHashMap collection = (ConcurrentHashMap)propertySource.getSource();
        collection.put(key, value);
    }

    @EventListener
    @Order(value=-100)
    public void getRefreshedEvent(RefreshedEvent refreshedEvent) {
        for (Map.Entry<String, String> item : refreshedEvent.getData().entrySet()) {
            this.update(item.getKey(), item.getValue());
        }
        this.refresh();
    }
}

