/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.properties;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="project")
public class ProjectProperties
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ProjectProperties.class);
    public static final String PREFIX = "project";
    @Value(value="${project.name:${spring.application.name:project}}")
    private String name;
    @Value(value="${server.address:${spring.application.address:}}")
    private String address;
    @Value(value="${server.port:8080}")
    private int port;
    private List<String> ignoredInterfaces = new ArrayList<String>();
    private boolean useOnlySiteLocalInterfaces = false;
    private List<String> preferredNetworks = new ArrayList<String>();

    public void afterPropertiesSet() throws Exception {
        if (Strings.isNullOrEmpty((String)this.address)) {
            this.address = this.getHostAddress();
        }
        log.info("{}", (Object)this);
    }

    private String getHostAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5f02\u5e38", (Throwable)e);
        }
        return "";
    }

    private InetAddress findFirstNonLoopBackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.trace("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() >= lowest && result != null && result != null) continue;
                lowest = ifc.getIndex();
                if (this.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || !this.isPreferredAddress(address)) continue;
                    log.trace("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException var8) {
            log.error("Cannot get first non-loopback address", (Throwable)var8);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException var7) {
            log.warn("Unable to retrieve localhost");
            return null;
        }
    }

    boolean ignoreInterface(String interfaceName) {
        String regex;
        Iterator<String> iterator = this.ignoredInterfaces.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!interfaceName.matches(regex = iterator.next()));
        log.trace("Ignoring interface: " + interfaceName);
        return true;
    }

    private boolean isPreferredAddress(InetAddress address) {
        String regex;
        String hostAddress;
        if (this.useOnlySiteLocalInterfaces) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress) {
                log.trace("Ignoring address: " + address.getHostAddress());
            }
            return siteLocalAddress;
        }
        List<String> preferredNetworks = this.preferredNetworks;
        if (preferredNetworks.isEmpty()) {
            return true;
        }
        Iterator<String> var3 = preferredNetworks.iterator();
        do {
            if (!var3.hasNext()) {
                log.trace("Ignoring address: " + address.getHostAddress());
                return false;
            }
            regex = var3.next();
        } while (!(hostAddress = address.getHostAddress()).matches(regex) && !hostAddress.startsWith(regex));
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getIgnoredInterfaces() {
        return this.ignoredInterfaces;
    }

    public boolean isUseOnlySiteLocalInterfaces() {
        return this.useOnlySiteLocalInterfaces;
    }

    public List<String> getPreferredNetworks() {
        return this.preferredNetworks;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIgnoredInterfaces(List<String> ignoredInterfaces) {
        this.ignoredInterfaces = ignoredInterfaces;
    }

    public void setUseOnlySiteLocalInterfaces(boolean useOnlySiteLocalInterfaces) {
        this.useOnlySiteLocalInterfaces = useOnlySiteLocalInterfaces;
    }

    public void setPreferredNetworks(List<String> preferredNetworks) {
        this.preferredNetworks = preferredNetworks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectProperties)) {
            return false;
        }
        ProjectProperties other = (ProjectProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isUseOnlySiteLocalInterfaces() != other.isUseOnlySiteLocalInterfaces()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        List<String> this$ignoredInterfaces = this.getIgnoredInterfaces();
        List<String> other$ignoredInterfaces = other.getIgnoredInterfaces();
        if (this$ignoredInterfaces == null ? other$ignoredInterfaces != null : !((Object)this$ignoredInterfaces).equals(other$ignoredInterfaces)) {
            return false;
        }
        List<String> this$preferredNetworks = this.getPreferredNetworks();
        List<String> other$preferredNetworks = other.getPreferredNetworks();
        return !(this$preferredNetworks == null ? other$preferredNetworks != null : !((Object)this$preferredNetworks).equals(other$preferredNetworks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUseOnlySiteLocalInterfaces() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        List<String> $ignoredInterfaces = this.getIgnoredInterfaces();
        result = result * 59 + ($ignoredInterfaces == null ? 43 : ((Object)$ignoredInterfaces).hashCode());
        List<String> $preferredNetworks = this.getPreferredNetworks();
        result = result * 59 + ($preferredNetworks == null ? 43 : ((Object)$preferredNetworks).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectProperties(name=" + this.getName() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", ignoredInterfaces=" + this.getIgnoredInterfaces() + ", useOnlySiteLocalInterfaces=" + this.isUseOnlySiteLocalInterfaces() + ", preferredNetworks=" + this.getPreferredNetworks() + ")";
    }
}

