/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.metrics;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import ltd.fdsa.core.metrics.Metrics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.serializer.Serializer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MetricsAspect {
    private static final Logger log = LoggerFactory.getLogger(MetricsAspect.class);
    private static Metrics DEFAULT_METRICS;
    @Autowired(required=false)
    Serializer<Object> serializer;

    @Pointcut(value="within(@Metrics *)")
    public void withMetricsAnnotationClass() {
    }

    @Pointcut(value="@annotation(Metrics)")
    public void annotationMetricsAnnotationMethod() {
    }

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void controllerBean() {
    }

    @Around(value="controllerBean() || annotationMetricsAnnotationMethod() || withMetricsAnnotationClass()")
    public Object metrics(ProceedingJoinPoint joinPoint) throws Throwable {
        Object returnValue;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Metrics metrics = signature.getMethod().getAnnotation(Metrics.class);
        if (metrics == null) {
            metrics = joinPoint.getTarget().getClass().getAnnotation(Metrics.class);
        }
        if (metrics == null) {
            metrics = DEFAULT_METRICS;
        }
        String name = String.format("\u3010%s\u3011\u3010%s\u3011", signature.getDeclaringType().toString(), signature.toLongString());
        if (metrics.logParameters()) {
            log.info(String.format("\u3010\u5165\u53c2\u65e5\u5fd7\u3011\u8c03\u7528 %s \u7684\u53c2\u6570\u662f\uff1a\u3010%s\u3011", name, this.serializer(joinPoint.getArgs())));
        }
        Instant start = Instant.now();
        try {
            returnValue = joinPoint.proceed();
            if (metrics.recordSuccessMetrics()) {
                log.info(String.format("\u3010\u6210\u529f\u6253\u70b9\u3011\u8c03\u7528 %s \u6210\u529f\uff0c\u8017\u65f6\uff1a%d ms", name, Duration.between(start, Instant.now()).toMillis()));
            }
        }
        catch (Exception ex) {
            if (metrics.recordFailMetrics()) {
                log.info(String.format("\u3010\u5931\u8d25\u6253\u70b9\u3011\u8c03\u7528 %s \u5931\u8d25\uff0c\u8017\u65f6\uff1a%d ms", name, Duration.between(start, Instant.now()).toMillis()));
            }
            if (metrics.logException()) {
                log.error(String.format("\u3010\u5f02\u5e38\u65e5\u5fd7\u3011\u8c03\u7528 %s \u51fa\u73b0\u5f02\u5e38\uff01", name), (Throwable)ex);
            }
            throw ex;
        }
        if (metrics.logReturn()) {
            log.info(String.format("\u3010\u51fa\u53c2\u65e5\u5fd7\u3011\u8c03\u7528 %s \u7684\u8fd4\u56de\u662f\uff1a\u3010%s\u3011", name, returnValue));
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String serializer(Object ... list) {
        if (list.length <= 0) {
            return "";
        }
        if (this.serializer == null) {
            log.warn("No Serializer");
            return "";
        }
        if (list.length == 1) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                this.serializer.serialize(list[0], (OutputStream)stream);
                String string = new String(stream.toByteArray());
                return string;
            }
            catch (IOException e) {
                return "";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = list;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                this.serializer.serialize(object, (OutputStream)stream);
                stringBuilder.append(new String(stream.toByteArray()));
                stream.reset();
            }
            catch (IOException e) {
                stringBuilder.append("\n");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    static {
        @Metrics
        final class C {
            C() {
            }
        }
        DEFAULT_METRICS = C.class.getAnnotation(Metrics.class);
    }
}

