/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import ltd.fdsa.core.context.ApplicationContextHolder;
import ltd.fdsa.core.lock.WithLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LockAspect {
    private static final Logger log = LoggerFactory.getLogger(LockAspect.class);

    @Pointcut(value="@annotation(WithLock)")
    public void annotationLockMethod() {
    }

    @Around(value="annotationLockMethod()")
    public Object metrics(ProceedingJoinPoint joinPoint) throws Throwable {
        WithLock withLock = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(WithLock.class);
        Lock lock = ApplicationContextHolder.getLockManager(withLock.lockManager()).getLock(withLock.lockKey());
        if (lock.tryLock(withLock.timeOutSeconds(), TimeUnit.SECONDS)) {
            Object returnValue;
            try {
                returnValue = joinPoint.proceed();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                lock.unlock();
            }
            return returnValue;
        }
        return null;
    }
}

