/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.event;

import ltd.fdsa.core.serializer.JsonSerializer;
import ltd.fdsa.core.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class RemotingEvent
extends ApplicationEvent {
    private static final Logger log = LoggerFactory.getLogger(RemotingEvent.class);
    public static Serializer SERIALIZER = new JsonSerializer();
    private final ApplicationEvent target;
    private final String name;

    public ApplicationEvent getTarget() {
        return this.target;
    }

    public RemotingEvent(ApplicationEvent target) {
        super(target.getSource());
        this.target = target;
        this.name = this.target.getClass().getCanonicalName();
    }

    public static <T extends ApplicationEvent> T getApplicationEvent(String payload, Class<T> tClass) {
        try {
            return (T)((ApplicationEvent)SERIALIZER.deserialize(payload, tClass));
        }
        catch (Exception ex) {
            log.error("deserialize failed:", (Throwable)ex);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPayload() {
        try {
            String result = SERIALIZER.serialize(this.target);
            return result;
        }
        catch (Exception ex) {
            log.error("serialize failed:", (Throwable)ex);
            return "";
        }
    }
}

