/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.core.context;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import ltd.fdsa.core.event.RemoteEventPublisher;
import ltd.fdsa.core.event.RemotingEvent;
import ltd.fdsa.core.lock.LockManager;
import ltd.fdsa.core.lock.ReentrantLockManager;
import ltd.fdsa.core.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.ClassUtils;

public class ApplicationContextHolder
implements ApplicationContextAware,
InstantiationAwareBeanPostProcessor,
ApplicationListener<RemotingEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationContextHolder.class);
    private static final ThreadLocal<Map<String, Object>> OBJECT_HOLDER = new NamedThreadLocal("objectHolder");
    private static ApplicationContext APPLICATION_CONTEXT;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public void onApplicationEvent(RemotingEvent event) {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)event.getName(), null);
        }
        catch (ClassNotFoundException e) {
            log.error("onApplicationEvent", (Throwable)e);
        }
        Object applicationEvent = RemotingEvent.getApplicationEvent(event.getPayload(), clazz);
        if (applicationEvent != null) {
            ApplicationContextHolder.publishLocal(applicationEvent);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        NamingUtils.formatLog(log, "ApplicationContext has been set", new Object[0]);
        APPLICATION_CONTEXT = applicationContext;
    }

    public static Map<String, CacheManager> getCacheManagers() {
        return APPLICATION_CONTEXT.getBeansOfType(CacheManager.class);
    }

    public static CacheManager getCacheManager(String ... name) {
        if (name.length <= 0 || Strings.isNullOrEmpty((String)name[0])) {
            return new NoOpCacheManager();
        }
        Map list = APPLICATION_CONTEXT.getBeansOfType(CacheManager.class);
        if (list.containsKey(name[0])) {
            return (CacheManager)list.get(name[0]);
        }
        return new NoOpCacheManager();
    }

    public static Map<String, LockManager> getLockManagers() {
        return APPLICATION_CONTEXT.getBeansOfType(LockManager.class);
    }

    public static LockManager getLockManager(String name) {
        Map list = APPLICATION_CONTEXT.getBeansOfType(LockManager.class);
        if (list.containsKey(name)) {
            return (LockManager)list.get(name);
        }
        return new ReentrantLockManager();
    }

    public static ThreadContext getThreadContext() {
        return new ThreadContext();
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)APPLICATION_CONTEXT.getBean(requiredType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        return APPLICATION_CONTEXT.getBeansOfType(requiredType);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return APPLICATION_CONTEXT.getBeansWithAnnotation(annotationType);
    }

    public static void publishRemote(ApplicationEvent event) {
        if (event == null) {
            log.warn("Event must not be null");
            return;
        }
        Map list = APPLICATION_CONTEXT.getBeansOfType(RemoteEventPublisher.class);
        if (list.size() <= 0) {
            log.warn("Event Service must not be null");
            ApplicationContextHolder.publishLocal(event);
            return;
        }
        list.forEach((name, publisher) -> publisher.send(new RemotingEvent(event)));
    }

    public static void publishLocal(ApplicationEvent event) {
        APPLICATION_CONTEXT.publishEvent(event);
    }

    static class ThreadContext {
        ThreadContext() {
        }

        public <T> T get(String name) {
            Map map = (Map)OBJECT_HOLDER.get();
            if (map == null) {
                return null;
            }
            Object result = map.get(name);
            if (result == null) {
                return null;
            }
            return (T)result;
        }

        public void set(String name, Object value) {
            HashMap<String, Object> map = (HashMap<String, Object>)OBJECT_HOLDER.get();
            if (map == null) {
                map = new HashMap<String, Object>();
                OBJECT_HOLDER.set(map);
            }
            map.put(name, value);
        }

        public void remove(String name) {
            Map map = (Map)OBJECT_HOLDER.get();
            if (map != null) {
                map.remove(name);
            }
        }

        public void clear() {
            Map map = (Map)OBJECT_HOLDER.get();
            if (map != null) {
                map.clear();
            }
        }
    }
}

