/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class WeakReferenceList
implements Serializable,
Cloneable {
    private Object master;
    private Reference[] childs;
    private int size;
    private final int maxChilds;

    protected WeakReferenceList(int maxChildCount) {
        this.maxChilds = maxChildCount;
        this.childs = new Reference[maxChildCount - 1];
    }

    public boolean add(Object rs) {
        if (this.size == 0) {
            this.master = rs;
            this.size = 1;
            return true;
        }
        if (this.size < this.getMaxChildCount()) {
            this.childs[this.size - 1] = this.createReference(rs);
            ++this.size;
            return true;
        }
        return false;
    }

    private Reference createReference(Object o) {
        return new WeakReference<Object>(o);
    }

    public Object get(int index) {
        if (this.isMaster(index)) {
            return this.master;
        }
        Reference ref = this.childs[this.getChildPos(index)];
        if (ref == null) {
            throw new IllegalStateException("State: " + index);
        }
        Object ob = ref.get();
        if (ob == null) {
            ob = this.restoreChild(index);
            this.childs[this.getChildPos((int)index)] = this.createReference(ob);
        }
        return ob;
    }

    protected int getChildPos(int index) {
        return index % this.getMaxChildCount() - 1;
    }

    protected Object getMaster() {
        return this.master;
    }

    protected final int getMaxChildCount() {
        return this.maxChilds;
    }

    public int getSize() {
        return this.size;
    }

    protected boolean isMaster(int index) {
        return index % this.getMaxChildCount() == 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.childs = new Reference[this.getMaxChildCount() - 1];
        int i = 0;
        while (i < this.childs.length) {
            this.childs[i] = this.createReference(null);
            ++i;
        }
    }

    protected abstract Object restoreChild(int var1);

    public void set(Object report, int index) {
        if (this.isMaster(index)) {
            this.master = report;
        } else {
            this.childs[this.getChildPos((int)index)] = this.createReference(report);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Reference[] orgChilds = this.childs;
        try {
            this.childs = null;
            out.defaultWriteObject();
        }
        finally {
            Object var4_3 = null;
            this.childs = orgChilds;
        }
    }
}

