/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class ReportProperties
implements Serializable,
Cloneable {
    private HashMap properties;
    private TreeSet markedProperties;

    public ReportProperties() {
        this.properties = new HashMap();
        this.markedProperties = new TreeSet();
        this.markedProperties = new TreeSet();
    }

    public ReportProperties(ReportProperties props) {
        this.properties = new HashMap(props.properties);
        this.markedProperties = new TreeSet();
    }

    public void clear() {
        this.properties.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportProperties p = (ReportProperties)super.clone();
        p.properties = (HashMap)this.properties.clone();
        p.markedProperties = (TreeSet)this.markedProperties.clone();
        return p;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.containsKey (..): Parameter key must not be null");
        }
        return this.properties.containsKey(key);
    }

    public boolean containsMarkedProperties() {
        return !this.markedProperties.isEmpty();
    }

    public Object get(String key) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.get (..): Parameter 'key' must not be null");
        }
        return this.properties.get(key);
    }

    public Object get(String key, Object defaultValue) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.get (..): Parameter 'key' must not be null");
        }
        Object o = this.properties.get(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public boolean isMarked(String property) {
        if (property == null) {
            throw new NullPointerException("ReportProperties.isMarked (..): Parameter property must not be null");
        }
        return this.markedProperties.contains(property);
    }

    public Iterator keys() {
        TreeSet list = new TreeSet();
        list.addAll(this.properties.keySet());
        list.addAll(this.markedProperties);
        return list.iterator();
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.put (..): Parameter 'key' must not be null");
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void setMarked(String property, boolean marked) {
        if (property == null) {
            throw new NullPointerException("ReportProperties.setMarked (..): Parameter property must not be null");
        }
        if (marked) {
            this.markedProperties.add(property);
        } else {
            this.markedProperties.remove(property);
        }
    }
}

