/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;

public abstract class PropertyLookupParser
implements Serializable {
    private static final int EXPECT_DOLLAR = 0;
    private static final int EXPECT_OPEN_BRACE = 1;
    private static final int EXPECT_CLOSE_BRACE = 2;
    private char markerChar = (char)36;
    private char closingBraceChar = (char)125;
    private char openingBraceChar = (char)123;
    private char escapeChar = (char)92;

    protected PropertyLookupParser() {
    }

    private static String continueLookupVariable(CSVTokenizer tokenizer, Object parent) throws BeanException {
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = ConverterRegistry.toPropertyValue(name, parent.getClass());
            if (tokenizer.hasMoreTokens()) {
                return PropertyLookupParser.continueLookupVariable(tokenizer, base);
            }
            return ConverterRegistry.toAttributeValue(base);
        }
        return null;
    }

    public char getClosingBraceChar() {
        return this.closingBraceChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }

    public char getOpeningBraceChar() {
        return this.openingBraceChar;
    }

    protected String lookupVariable(String entity) {
        CSVTokenizer tokenizer = new CSVTokenizer(entity, ".");
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = this.performInitialLookup(name);
            try {
                if (tokenizer.hasMoreTokens()) {
                    return PropertyLookupParser.continueLookupVariable(tokenizer, base);
                }
                return ConverterRegistry.toAttributeValue(base);
            }
            catch (BeanException beanException) {
                return entity;
            }
        }
        return entity;
    }

    protected abstract Object performInitialLookup(String var1);

    public void setClosingBraceChar(char closingBraceChar) {
        this.closingBraceChar = closingBraceChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public void setMarkerChar(char markerChar) {
        this.markerChar = markerChar;
    }

    public void setOpeningBraceChar(char openingBraceChar) {
        this.openingBraceChar = openingBraceChar;
    }

    /*
     * Unable to fully structure code
     */
    public String translateAndLookup(String value) {
        if (value == null) {
            return null;
        }
        chars = value.toCharArray();
        result = new StringBuffer(chars.length);
        haveEscape = false;
        state = 0;
        propertyName = new StringBuffer();
        i = 0;
        while (i < chars.length) {
            block17: {
                block18: {
                    block16: {
                        c = chars[i];
                        if (!haveEscape) break block16;
                        haveEscape = false;
                        if (state == 2) {
                            propertyName.append(c);
                        } else {
                            result.append(c);
                        }
                        break block17;
                    }
                    if (state != 0 || c != this.markerChar) break block18;
                    state = 1;
                    break block17;
                }
                if (state != 1) ** GOTO lbl32
                if (c == this.openingBraceChar) {
                    state = 2;
                } else {
                    result.append(this.markerChar);
                    state = 0;
lbl32:
                    // 2 sources

                    if (state == 2 && c == this.closingBraceChar) {
                        s = this.lookupVariable(propertyName.toString());
                        if (s == null) {
                            result.append(this.markerChar);
                            result.append(this.openingBraceChar);
                            result.append((Object)propertyName);
                            result.append(this.closingBraceChar);
                        } else {
                            result.append(s);
                        }
                        propertyName.delete(0, propertyName.length());
                        state = 0;
                    } else if (c == this.escapeChar) {
                        haveEscape = true;
                    } else if (state == 2) {
                        propertyName.append(c);
                    } else {
                        result.append(c);
                    }
                }
            }
            ++i;
        }
        if (state >= 1) {
            result.append(this.markerChar);
            if (state >= 2) {
                result.append(this.openingBraceChar);
                result.append((Object)propertyName);
            }
        }
        return result.toString();
    }
}

