/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class LevelList
implements Cloneable {
    private static final Integer ZERO = new Integer(0);
    private transient TreeSet iteratorSetAsc;
    private transient TreeSet iteratorSetDesc;
    private HashMap iteratorCache;
    private ArrayList elements = new ArrayList();
    private ArrayList levels = new ArrayList();

    public LevelList() {
        this.iteratorCache = new HashMap();
    }

    public synchronized void add(Object o) {
        this.elements.add(o);
        this.levels.add(ZERO);
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
        this.iteratorCache.remove(ZERO);
    }

    public synchronized void add(Object o, int level) {
        this.elements.add(o);
        Integer i = new Integer(level);
        this.levels.add(i);
        this.iteratorCache.remove(i);
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
    }

    public synchronized void clear() {
        this.elements.clear();
        this.levels.clear();
        this.iteratorCache.clear();
        this.iteratorSetAsc = null;
        this.iteratorSetDesc = null;
    }

    public Object clone() throws CloneNotSupportedException {
        LevelList l = (LevelList)super.clone();
        l.elements = (ArrayList)this.elements.clone();
        l.levels = (ArrayList)this.levels.clone();
        l.iteratorCache = (HashMap)this.iteratorCache.clone();
        return l;
    }

    public synchronized Object get(int index) {
        return this.elements.get(index);
    }

    public Object[] getElementArrayForLevel(int level) {
        return this.getElementArrayForLevel(level, null);
    }

    public Object[] getElementArrayForLevel(int level, Object[] target) {
        ElementLevelList it = (ElementLevelList)this.iteratorCache.get(new Integer(level));
        if (it == null) {
            class Org_jfree_report_util_LevelList$1 {
                /* synthetic */ Org_jfree_report_util_LevelList$1() {
                }
            }
            it = new ElementLevelList(null, this, level);
            this.iteratorCache.put(new Integer(level), it);
        }
        if (target == null) {
            return it.getData();
        }
        return it.getData(target);
    }

    public int getElementCountForLevel(int level) {
        ElementLevelList it = (ElementLevelList)this.iteratorCache.get(new Integer(level));
        if (it == null) {
            it = new ElementLevelList(null, this, level);
            this.iteratorCache.put(new Integer(level), it);
        }
        return it.size();
    }

    protected Iterator getElementsForLevel(int level) {
        return Collections.unmodifiableList(Arrays.asList(this.getElementArrayForLevel(level))).iterator();
    }

    public int getLevel(int index) {
        return (Integer)this.levels.get(index);
    }

    public int getLevel(Object o) {
        return this.getLevel(this.indexOf(o));
    }

    public synchronized Iterator getLevelsAscending() {
        if (this.iteratorSetAsc == null) {
            this.iteratorSetAsc = new TreeSet();
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            int i = 0;
            while (i < ilevels.length) {
                if (!this.iteratorSetAsc.contains(ilevels[i])) {
                    this.iteratorSetAsc.add(ilevels[i]);
                }
                ++i;
            }
        }
        return this.iteratorSetAsc.iterator();
    }

    public synchronized Iterator getLevelsDescending() {
        if (this.iteratorSetDesc == null) {
            this.iteratorSetDesc = new TreeSet(new DescendingComparator());
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            int i = 0;
            while (i < ilevels.length) {
                if (!this.iteratorSetDesc.contains(ilevels[i])) {
                    this.iteratorSetDesc.add(ilevels[i]);
                }
                ++i;
            }
        }
        return this.iteratorSetDesc.iterator();
    }

    public synchronized Integer[] getLevelsDescendingArray() {
        if (this.iteratorSetDesc == null) {
            this.iteratorSetDesc = new TreeSet(new DescendingComparator());
            Integer[] ilevels = this.levels.toArray(new Integer[this.levels.size()]);
            int i = 0;
            while (i < ilevels.length) {
                if (!this.iteratorSetDesc.contains(ilevels[i])) {
                    this.iteratorSetDesc.add(ilevels[i]);
                }
                ++i;
            }
        }
        return this.iteratorSetDesc.toArray(new Integer[this.iteratorSetDesc.size()]);
    }

    protected Object[] getRawElements() {
        return this.elements.toArray(new Object[this.elements.size()]);
    }

    protected Integer[] getRawLevels() {
        return this.levels.toArray(new Integer[this.levels.size()]);
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public void setLevel(int index, int level) {
        this.levels.set(index, new Integer(level));
    }

    public void setLevel(Object o, int level) {
        this.setLevel(this.indexOf(o), level);
    }

    public int size() {
        return this.elements.size();
    }

    public synchronized Object[] toArray() {
        return this.elements.toArray();
    }

    private static final class DescendingComparator
    implements Comparator {
        private DescendingComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            if (!(o2 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return -1 * c1.compareTo(c2);
        }
    }

    private static final class ElementLevelList {
        private ArrayList datalist;

        /* synthetic */ ElementLevelList(1 $0, LevelList $1, int $2) {
            this($1, $2);
        }

        private ElementLevelList(LevelList list, int level) {
            if (list == null) {
                throw new NullPointerException();
            }
            Object[] rawElements = list.getRawElements();
            Integer[] rawLevels = list.getRawLevels();
            this.datalist = new ArrayList(rawElements.length);
            int i = 0;
            while (i < rawElements.length) {
                Object iNext = rawElements[i];
                Integer iLevel = rawLevels[i];
                if (iLevel == level) {
                    this.datalist.add(iNext);
                }
                ++i;
            }
        }

        protected Object[] getData() {
            return this.datalist.toArray();
        }

        protected Object[] getData(Object[] target) {
            return this.datalist.toArray(target);
        }

        protected int size() {
            return this.datalist.size();
        }
    }
}

