/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.jfree.util.Log;

public final class EncodingSupport {
    private static HashMap knownEncodings;
    private static final String TEST_STRING = " ";

    private EncodingSupport() {
    }

    public static boolean isSupportedEncoding(String encoding) {
        Boolean value;
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (knownEncodings == null) {
            knownEncodings = new HashMap();
        }
        if ((value = (Boolean)knownEncodings.get(encoding)) != null) {
            return value;
        }
        try {
            TEST_STRING.getBytes(encoding);
            knownEncodings.put(encoding, Boolean.TRUE);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            knownEncodings.put(encoding, Boolean.FALSE);
            Log.info((Object)new Log.SimpleMessage("Encoding ", (Object)encoding, (Object)" is not supported."));
            return false;
        }
    }
}

