/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.style;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleChangeListener;
import org.jfree.report.style.StyleKey;

public class StyleChangeSupport {
    private ArrayList listeners;
    private final ElementStyleSheet source;

    public StyleChangeSupport(ElementStyleSheet source) {
        this.source = source;
    }

    public void addListener(StyleChangeListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listeners.add(new WeakReference<StyleChangeListener>(l));
    }

    public void fireStyleChanged(StyleKey key, Object value) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<WeakReference> removeList = null;
        int i = 0;
        while (i < this.listeners.size()) {
            WeakReference ref = (WeakReference)this.listeners.get(i);
            StyleChangeListener l = (StyleChangeListener)ref.get();
            if (l != null) {
                l.styleChanged(this.source, key, value);
            } else {
                if (removeList == null) {
                    removeList = new ArrayList<WeakReference>(5);
                }
                removeList.add(ref);
            }
            ++i;
        }
        if (removeList != null) {
            ((AbstractCollection)this.listeners).removeAll(removeList);
        }
    }

    public void fireStyleRemoved(StyleKey key) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<WeakReference> removeList = null;
        int i = 0;
        while (i < this.listeners.size()) {
            WeakReference ref = (WeakReference)this.listeners.get(i);
            StyleChangeListener l = (StyleChangeListener)ref.get();
            if (l != null) {
                l.styleRemoved(this.source, key);
            } else {
                if (removeList == null) {
                    removeList = new ArrayList<WeakReference>(5);
                }
                removeList.add(ref);
            }
            ++i;
        }
        if (removeList != null) {
            ((AbstractCollection)this.listeners).removeAll(removeList);
        }
    }

    public void removeListener(StyleChangeListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            return;
        }
        ((AbstractCollection)this.listeners).remove(l);
    }
}

