/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.jfree.report.DataRow;
import org.jfree.report.function.Expression;
import org.jfree.report.function.LevelledExpressionList;
import org.jfree.report.states.DataRowConnector;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.ReportPropertiesList;
import org.jfree.util.Log;

public class DataRowBackend
implements Cloneable {
    private final HashMap colcache;
    private LevelledExpressionList functions;
    private TableModel tablemodel;
    private ReportPropertiesList reportProperties;
    private int currentRow = -1;
    private boolean[] columnlocks;
    private final boolean warnInvalidColumns;
    private static final boolean[] EMPTY_BOOLS = new boolean[0];
    private int functionsEndIndex;
    private int propertiesEndIndex;
    private int tableEndIndex;
    private int lastRow;
    private DataRowConnector dataRowConnector;

    public DataRowBackend() {
        this.columnlocks = EMPTY_BOOLS;
        this.dataRowConnector = new DataRowConnector();
        this.dataRowConnector.setDataRowBackend(this);
        this.colcache = new HashMap();
        this.warnInvalidColumns = ReportConfiguration.getGlobalConfig().isWarnInvalidColumns();
        this.lastRow = -1;
        this.revalidateColumnLock();
    }

    protected DataRowBackend(DataRowBackend db) {
        this.dataRowConnector = new DataRowConnector();
        this.dataRowConnector.setDataRowBackend(this);
        this.columnlocks = EMPTY_BOOLS;
        this.colcache = new HashMap();
        this.warnInvalidColumns = db.warnInvalidColumns;
        this.tablemodel = db.tablemodel;
        this.lastRow = db.lastRow;
        this.reportProperties = db.reportProperties;
        this.revalidateColumnLock();
    }

    public Object clone() throws CloneNotSupportedException {
        DataRowBackend db = (DataRowBackend)super.clone();
        db.columnlocks = new boolean[this.getColumnCount()];
        db.dataRowConnector = new DataRowConnector();
        db.dataRowConnector.setDataRowBackend(db);
        if (this.functions != null) {
            db.functions = (LevelledExpressionList)this.functions.clone();
            db.functions.updateDataRow(db.dataRowConnector);
        }
        return db;
    }

    public int findColumn(String name) {
        Integer integ = (Integer)this.colcache.get(name);
        if (integ != null) {
            return integ;
        }
        int size = this.getColumnCount();
        int i = 0;
        while (i < size) {
            String column = this.getColumnName(i);
            if (column.equals(name)) {
                this.colcache.put(name, new Integer(i));
                return i;
            }
            ++i;
        }
        if (this.warnInvalidColumns) {
            Log.warn(new Log.SimpleMessage("Invalid column name specified on query: ", (Object)name));
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(int column) {
        Object returnValue;
        block10: {
            if (column >= this.getColumnCount()) {
                throw new IndexOutOfBoundsException("requested " + column + " , have " + this.getColumnCount());
            }
            if (column < 0) {
                throw new IndexOutOfBoundsException("Column with negative index is invalid");
            }
            if (this.columnlocks[column]) {
                throw new IllegalStateException("Column " + column + " already accessed. Deadlock!");
            }
            returnValue = null;
            try {
                Object object;
                try {
                    this.columnlocks[column] = true;
                    int col = column;
                    if (col < this.getTableEndIndex()) {
                        int currentRow = this.getCurrentRow();
                        returnValue = currentRow < 0 || currentRow > this.lastRow ? null : this.getTablemodel().getValueAt(currentRow, col);
                        break block10;
                    }
                    if (col < this.getFunctionEndIndex()) {
                        returnValue = this.getFunctions().getValue(col -= this.getTableEndIndex());
                        break block10;
                    }
                    if (col >= this.getPropertiesEndIndex()) break block10;
                    object = this.getReportProperties().get(col -= this.getFunctionEndIndex());
                    Object var5_8 = null;
                }
                catch (IllegalStateException ise) {
                    throw ise;
                }
                catch (Exception e) {
                    Log.error(new Log.SimpleMessage("Column ", (Object)new Integer(column), (Object)" caused an error on get()", (Object)e));
                    break block10;
                }
                this.columnlocks[column] = false;
                return object;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.columnlocks[column] = false;
                throw throwable;
            }
        }
        Object var5_9 = null;
        this.columnlocks[column] = false;
        return returnValue;
    }

    public Object get(String name) {
        int idx = this.findColumn(name);
        if (idx == -1) {
            return null;
        }
        return this.get(idx);
    }

    public int getColumnCount() {
        return this.propertiesEndIndex;
    }

    public String getColumnName(int col) {
        if (col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("requested " + col + " , have " + this.getColumnCount());
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException("Requested Column cannot be negative");
        }
        if (col < this.getTableEndIndex()) {
            return this.getTablemodel().getColumnName(col);
        }
        if (col < this.getFunctionEndIndex()) {
            Expression f = this.getFunctions().getExpression(col -= this.getTableEndIndex());
            if (f == null) {
                Log.warn("No such function: " + col);
                return null;
            }
            return f.getName();
        }
        return this.getReportProperties().getColumnName(col -= this.getFunctionEndIndex());
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public DataRow getDataRow() {
        return this.getDataRowConnector();
    }

    protected DataRowConnector getDataRowConnector() {
        return this.dataRowConnector;
    }

    private int getFunctionEndIndex() {
        return this.functionsEndIndex;
    }

    public LevelledExpressionList getFunctions() {
        return this.functions;
    }

    private int getPropertiesEndIndex() {
        return this.propertiesEndIndex;
    }

    public ReportPropertiesList getReportProperties() {
        return this.reportProperties;
    }

    private int getTableEndIndex() {
        return this.tableEndIndex;
    }

    public TableModel getTablemodel() {
        return this.tablemodel;
    }

    public boolean isBeforeFirstRow() {
        return this.getCurrentRow() < 0;
    }

    public boolean isLastRow() {
        return this.getCurrentRow() == this.lastRow;
    }

    private void revalidateColumnLock() {
        this.tableEndIndex = this.getTablemodel() == null ? 0 : this.getTablemodel().getColumnCount();
        this.functionsEndIndex = this.getFunctions() == null ? this.tableEndIndex : this.tableEndIndex + this.getFunctions().size();
        this.propertiesEndIndex = this.getReportProperties() == null ? this.functionsEndIndex : this.functionsEndIndex + this.getReportProperties().getColumnCount();
        if (this.getColumnCount() != this.columnlocks.length) {
            this.columnlocks = new boolean[this.getColumnCount()];
        }
    }

    public void setCurrentRow(int currentRow) {
        if (currentRow < -1) {
            throw new IllegalArgumentException("CurrentRow must not be < -1");
        }
        if (this.getTablemodel() != null) {
            if (currentRow > this.getTablemodel().getRowCount()) {
                throw new IllegalArgumentException("CurrentRow cannot be greater than the tablemodel's rowcount." + currentRow);
            }
        } else if (currentRow != -1) {
            throw new IllegalArgumentException("Without an TableModel, the currentRow must always be -1");
        }
        this.currentRow = currentRow;
    }

    public void setFunctions(LevelledExpressionList functions) {
        if (this.functions != null) {
            this.functions.setDataRow(null);
        }
        this.functions = functions;
        if (this.functions != null) {
            this.functions.setDataRow(this.getDataRow());
        }
        this.revalidateColumnLock();
    }

    public void setReportProperties(ReportPropertiesList properties) {
        this.reportProperties = properties;
        this.revalidateColumnLock();
    }

    public void setTablemodel(TableModel tablemodel) {
        this.tablemodel = tablemodel;
        this.lastRow = tablemodel != null ? tablemodel.getRowCount() - 1 : -1;
        this.revalidateColumnLock();
    }
}

