/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.layout.StaticLayoutManager;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.ReportParserUtil;
import org.jfree.report.modules.parser.simple.FontFactory;
import org.jfree.report.modules.parser.simple.readhandlers.AnchorFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.DateFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.DrawableFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.DrawableRefReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.DrawableURLFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ImageFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ImageRefReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ImageURLFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.LabelReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.LineReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.MessageFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.NumberFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.RectangleReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ResourceFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ResourceLabelReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ShapeFieldReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.StringFieldReadHandler;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.ui.FloatDimension;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BandReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String LABEL_TAG = "label";
    public static final String STRING_FIELD_TAG = "string-field";
    public static final String NUMBER_FIELD_TAG = "number-field";
    public static final String DATE_FIELD_TAG = "date-field";
    public static final String IMAGEREF_TAG = "imageref";
    public static final String IMAGEFIELD_TAG = "image-field";
    public static final String IMAGEURLFIELD_TAG = "imageurl-field";
    public static final String RECTANGLE_TAG = "rectangle";
    public static final String RESOURCELABEL_TAG = "resource-label";
    public static final String RESOURCEFIELD_TAG = "resource-field";
    public static final String LINE_TAG = "line";
    public static final String DRAWABLE_FIELD_TAG = "drawable-field";
    public static final String SHAPE_FIELD_TAG = "shape-field";
    public static final String BAND_TAG = "band";
    public static final String MESSAGE_FIELD_TAG = "message-field";
    public static final String ANCHOR_FIELD_TAG = "anchor-field";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";
    private static final String NAME_ATT = "name";
    private static final String COLOR_ATT = "color";
    public static final String RESERVED_LITERAL_ATT = "reserved-literal";
    private Band band;
    private ArrayList elementHandlers;
    private static final String DRAWABLE_REF_TAG = "drawableref";
    private static final String DRAWABLE_URL_FIELD_TAG = "drawable-url-field";

    public BandReadHandler() {
        this(new Band());
    }

    protected BandReadHandler(Band band) {
        this.band = band;
        this.elementHandlers = new ArrayList();
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        int i = 0;
        while (i < this.elementHandlers.size()) {
            XmlReadHandler readHandler = (XmlReadHandler)this.elementHandlers.get(i);
            Element e = (Element)readHandler.getObject();
            this.band.addElement(e);
            ++i;
        }
        super.doneParsing();
    }

    protected Band getBand() {
        return this.band;
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals(LABEL_TAG)) {
            LabelReadHandler readHandler = new LabelReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(STRING_FIELD_TAG)) {
            StringFieldReadHandler readHandler = new StringFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(NUMBER_FIELD_TAG)) {
            NumberFieldReadHandler readHandler = new NumberFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(DATE_FIELD_TAG)) {
            DateFieldReadHandler readHandler = new DateFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(IMAGEREF_TAG)) {
            ImageRefReadHandler readHandler = new ImageRefReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(IMAGEFIELD_TAG)) {
            ImageFieldReadHandler readHandler = new ImageFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(IMAGEURLFIELD_TAG)) {
            ImageURLFieldReadHandler readHandler = new ImageURLFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(RECTANGLE_TAG)) {
            RectangleReadHandler readHandler = new RectangleReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(RESOURCEFIELD_TAG)) {
            ResourceFieldReadHandler readHandler = new ResourceFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(RESOURCELABEL_TAG)) {
            ResourceLabelReadHandler readHandler = new ResourceLabelReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(LINE_TAG)) {
            LineReadHandler readHandler = new LineReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(MESSAGE_FIELD_TAG)) {
            MessageFieldReadHandler readHandler = new MessageFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(ANCHOR_FIELD_TAG)) {
            AnchorFieldReadHandler readHandler = new AnchorFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(DRAWABLE_FIELD_TAG)) {
            DrawableFieldReadHandler readHandler = new DrawableFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(DRAWABLE_URL_FIELD_TAG)) {
            DrawableURLFieldReadHandler readHandler = new DrawableURLFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(DRAWABLE_REF_TAG)) {
            DrawableRefReadHandler readHandler = new DrawableRefReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(SHAPE_FIELD_TAG)) {
            ShapeFieldReadHandler readHandler = new ShapeFieldReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals(BAND_TAG)) {
            BandReadHandler readHandler = new BandReadHandler();
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.band;
    }

    protected void handleAlignment(Attributes attr) throws SAXException {
        String halign;
        String valign = attr.getValue(VALIGNMENT_ATT);
        if (valign != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.VALIGNMENT, ReportParserUtil.parseVerticalElementAlignment(valign));
        }
        if ((halign = attr.getValue(ALIGNMENT_ATT)) != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.ALIGNMENT, ReportParserUtil.parseHorizontalElementAlignment(halign));
        }
    }

    private void handleColor(Attributes attr) {
        String colorValue = attr.getValue(COLOR_ATT);
        if (colorValue != null) {
            Color c = ParserUtil.parseColor((String)colorValue);
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.PAINT, c);
        }
    }

    private void handleLayoutCachable(Attributes attr) {
        String trimTextContent = attr.getValue("layout-cachable");
        if (trimTextContent != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, new Boolean(ParserUtil.parseBoolean((String)trimTextContent, (boolean)true)));
        }
    }

    protected void handleMinSize(Attributes attr) throws SAXException {
        String heightValue;
        String widthValue = attr.getValue("width");
        if (widthValue == null) {
            widthValue = "0";
        }
        if ((heightValue = attr.getValue("height")) == null) {
            heightValue = "0";
        }
        float w = ParserUtil.parseRelativeFloat((String)widthValue, (String)"Element width is invalid");
        float h = ParserUtil.parseRelativeFloat((String)heightValue, (String)"Element height is invalid");
        FloatDimension minSize = new FloatDimension(w, h);
        this.getBand().getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, minSize);
    }

    private void handlePosition(Attributes atts) throws SAXException {
        String yValue;
        String xValue = atts.getValue("x");
        if (xValue == null) {
            xValue = "0";
        }
        if ((yValue = atts.getValue("y")) == null) {
            yValue = "0";
        }
        float x = ParserUtil.parseRelativeFloat((String)xValue, (String)"Element x not valid");
        float y = ParserUtil.parseRelativeFloat((String)yValue, (String)"Element y not valid");
        this.getBand().getStyle().setStyleProperty(StaticLayoutManager.ABSOLUTE_POS, new Point2D.Float(x, y));
    }

    private void handleReservedLiteral(Attributes attr) {
        String reservedLiteral = attr.getValue(RESERVED_LITERAL_ATT);
        if (reservedLiteral != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.RESERVED_LITERAL, reservedLiteral);
        }
    }

    private void handleTrimTextContent(Attributes attr) {
        String trimTextContent = attr.getValue("trim-text-content");
        if (trimTextContent != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.TRIM_TEXT_CONTENT, new Boolean(ParserUtil.parseBoolean((String)trimTextContent, (boolean)true)));
        }
    }

    private void handleVisible(Attributes attr) {
        String trimTextContent = attr.getValue("visible");
        if (trimTextContent != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.VISIBLE, new Boolean(ParserUtil.parseBoolean((String)trimTextContent, (boolean)true)));
        }
    }

    protected void startParsing(PropertyAttributes attr) throws SAXException {
        String name = attr.getValue(NAME_ATT);
        if (name != null) {
            this.band.setName(name);
        }
        FontFactory.FontInformation fi = FontFactory.createFont(attr);
        FontFactory.applyFontInformation(this.band.getStyle(), fi);
        this.handleColor(attr);
        this.handleMinSize(attr);
        this.handleAlignment(attr);
        this.handlePosition(attr);
        this.handleReservedLiteral(attr);
        this.handleTrimTextContent(attr);
        this.handleVisible(attr);
        this.handleLayoutCachable(attr);
    }

    protected void storeComments() throws SAXException {
        CommentHintPath commentHintPath = new CommentHintPath(this.band);
        this.defaultStoreComments(commentHintPath);
    }
}

