/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import org.jfree.report.ElementAlignment;
import org.jfree.report.elementfactory.ElementFactory;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public abstract class AbstractTextElementReadHandler
extends AbstractElementReadHandler {
    public static final String RESERVED_LITERAL_ATT = "reserved-literal";
    public static final String TRIM_TEXT_CONTENT_ATT = "trim-text-content";
    public static final String WRAP_TEXT = "excel-wrap-text";

    protected final ElementFactory getElementFactory() {
        return this.getTextElementFactory();
    }

    protected abstract TextElementFactory getTextElementFactory();

    private Boolean parseBoolean(String value) throws SAXException {
        if (value == null) {
            return null;
        }
        if (value.equals("true")) {
            return Boolean.TRUE;
        }
        if (value.equals("false")) {
            return Boolean.FALSE;
        }
        throw new SAXException("Failed to parse value: Expected 'true' or 'false'");
    }

    private Float parseFloat(String value) throws SAXException {
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (Exception ex) {
            throw new SAXException("Failed to parse value", ex);
        }
    }

    private Integer parseInteger(String val) throws SAXException {
        if (val == null) {
            return null;
        }
        try {
            return new Integer(val);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Failed to parse value", e);
        }
    }

    private void parseSimpleFontStyle(String fontStyle, TextElementFactory target) {
        if (fontStyle != null) {
            if (fontStyle.equals("bold")) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.FALSE);
            } else if (fontStyle.equals("italic")) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.TRUE);
            } else if (fontStyle.equals("bold-italic")) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.TRUE);
            } else if (fontStyle.equals("plain")) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.FALSE);
            }
        }
    }

    private ElementAlignment parseTextAlignment(String alignment) {
        ElementAlignment elementAlignment = null;
        if (alignment != null) {
            if (alignment.equals("left")) {
                elementAlignment = ElementAlignment.LEFT;
            }
            if (alignment.equals("center")) {
                elementAlignment = ElementAlignment.CENTER;
            }
            if (alignment.equals("right")) {
                elementAlignment = ElementAlignment.RIGHT;
            }
        }
        return elementAlignment;
    }

    private ElementAlignment parseTextVerticalAlignment(String alignment) {
        if (alignment != null) {
            if (alignment.equals("top")) {
                return ElementAlignment.TOP;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return ElementAlignment.MIDDLE;
            }
            if (alignment.equals("bottom")) {
                return ElementAlignment.BOTTOM;
            }
        }
        return null;
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        super.startParsing(atts);
        TextElementFactory factory = this.getTextElementFactory();
        factory.setHorizontalAlignment(this.parseTextAlignment(atts.getValue("alignment")));
        if (atts.getValue("color") != null) {
            factory.setColor(ParserUtil.parseColor((String)atts.getValue("color")));
        }
        factory.setVerticalAlignment(this.parseTextVerticalAlignment(atts.getValue("vertical-alignment")));
        factory.setBold(this.parseBoolean(atts.getValue("fsbold")));
        factory.setEmbedFont(this.parseBoolean(atts.getValue("font-embedded")));
        factory.setWrapText(this.parseBoolean(atts.getValue(WRAP_TEXT)));
        factory.setEncoding(atts.getValue("font-encoding"));
        factory.setFontName(atts.getValue("fontname"));
        factory.setFontSize(this.parseInteger(atts.getValue("fontsize")));
        factory.setItalic(this.parseBoolean(atts.getValue("fsitalic")));
        factory.setLineHeight(this.parseFloat(atts.getValue("line-height")));
        factory.setStrikethrough(this.parseBoolean(atts.getValue("fsstrikethr")));
        factory.setUnderline(this.parseBoolean(atts.getValue("fsunderline")));
        factory.setReservedLiteral(atts.getValue(RESERVED_LITERAL_ATT));
        factory.setTrimTextContent(this.parseBoolean(atts.getValue(TRIM_TEXT_CONTENT_ATT)));
        this.parseSimpleFontStyle(atts.getValue("fontstyle"), factory);
    }
}

