/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple;

import org.jfree.report.style.ElementStyleSheet;
import org.jfree.xml.ParserUtil;
import org.xml.sax.Attributes;

public final class FontFactory {
    public static final String FONT_NAME_ATT = "fontname";
    public static final String FONT_STYLE_ATT = "fontstyle";
    public static final String FONT_SIZE_ATT = "fontsize";
    public static final String FS_BOLD = "fsbold";
    public static final String FS_ITALIC = "fsitalic";
    public static final String FS_UNDERLINE = "fsunderline";
    public static final String FS_STRIKETHR = "fsstrikethr";
    public static final String FS_EMBEDDED = "font-embedded";
    public static final String FS_ENCODING = "font-encoding";
    public static final String LINEHEIGHT = "line-height";

    private FontFactory() {
    }

    public static void applyFontInformation(ElementStyleSheet es, FontInformation fi) {
        if (fi.getFontname() != null) {
            es.setStyleProperty(ElementStyleSheet.FONT, fi.getFontname());
        }
        if (fi.getFontSize() != null) {
            es.setStyleProperty(ElementStyleSheet.FONTSIZE, fi.getFontSize());
        }
        if (fi.getItalic() != null) {
            es.setStyleProperty(ElementStyleSheet.ITALIC, fi.getItalic());
        }
        if (fi.getBold() != null) {
            es.setStyleProperty(ElementStyleSheet.BOLD, fi.getBold());
        }
        if (fi.getUnderlined() != null) {
            es.setStyleProperty(ElementStyleSheet.UNDERLINED, fi.getUnderlined());
        }
        if (fi.getStrikeThrough() != null) {
            es.setStyleProperty(ElementStyleSheet.STRIKETHROUGH, fi.getStrikeThrough());
        }
        if (fi.getEmbedded() != null) {
            es.setStyleProperty(ElementStyleSheet.EMBEDDED_FONT, fi.getEmbedded());
        }
        if (fi.getFontencoding() != null) {
            es.setStyleProperty(ElementStyleSheet.FONTENCODING, fi.getFontencoding());
        }
        if (fi.getLineHeight() != null) {
            es.setStyleProperty(ElementStyleSheet.LINEHEIGHT, fi.getLineHeight());
        }
    }

    public static FontInformation createFont(Attributes attr) {
        FontInformation fi = new FontInformation();
        String elementFontName = attr.getValue(FONT_NAME_ATT);
        if (elementFontName != null) {
            fi.setFontname(elementFontName);
        }
        FontFactory.readSimpleFontStyle(attr, fi);
        Integer elementFontSize = FontFactory.parseInteger(attr.getValue(FONT_SIZE_ATT));
        if (elementFontSize != null) {
            fi.setFontSize(elementFontSize);
        }
        return fi;
    }

    public static void createFont(Attributes attr, ElementStyleSheet target) {
        String elementFontName = attr.getValue(FONT_NAME_ATT);
        if (elementFontName != null) {
            target.setStyleProperty(ElementStyleSheet.FONT, elementFontName);
        }
        FontInformation fi = new FontInformation();
        FontFactory.applyFontInformation(target, FontFactory.readSimpleFontStyle(attr, fi));
        Integer elementFontSize = FontFactory.parseInteger(attr.getValue(FONT_SIZE_ATT));
        if (elementFontSize != null) {
            target.setStyleProperty(ElementStyleSheet.FONTSIZE, elementFontSize);
        }
    }

    private static Boolean getBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Integer parseInteger(String val) {
        if (val == null) {
            return null;
        }
        try {
            return new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static FontInformation readSimpleFontStyle(Attributes attr, FontInformation target) {
        String fontStyle;
        if (target == null) {
            target = new FontInformation();
        }
        if ((fontStyle = attr.getValue(FONT_STYLE_ATT)) != null) {
            if (fontStyle.equals("bold")) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.FALSE);
            } else if (fontStyle.equals("italic")) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.TRUE);
            } else if (fontStyle.equals("bold-italic")) {
                target.setBold(Boolean.TRUE);
                target.setItalic(Boolean.TRUE);
            } else if (fontStyle.equals("plain")) {
                target.setBold(Boolean.FALSE);
                target.setItalic(Boolean.FALSE);
            }
        }
        if (attr.getValue(FS_BOLD) != null) {
            target.setBold(FontFactory.getBoolean(ParserUtil.parseBoolean((String)attr.getValue(FS_BOLD), (boolean)false)));
        }
        if (attr.getValue(FS_ITALIC) != null) {
            target.setItalic(FontFactory.getBoolean(ParserUtil.parseBoolean((String)attr.getValue(FS_ITALIC), (boolean)false)));
        }
        if (attr.getValue(FS_STRIKETHR) != null) {
            target.setStrikeThrough(FontFactory.getBoolean(ParserUtil.parseBoolean((String)attr.getValue(FS_STRIKETHR), (boolean)false)));
        }
        if (attr.getValue(FS_UNDERLINE) != null) {
            target.setUnderlined(FontFactory.getBoolean(ParserUtil.parseBoolean((String)attr.getValue(FS_UNDERLINE), (boolean)false)));
        }
        if (attr.getValue(FS_EMBEDDED) != null) {
            target.setEmbedded(FontFactory.getBoolean(ParserUtil.parseBoolean((String)attr.getValue(FS_EMBEDDED), (boolean)false)));
        }
        if (attr.getValue(FS_ENCODING) != null) {
            target.setFontencoding(attr.getValue(FS_ENCODING));
        }
        if (attr.getValue(LINEHEIGHT) != null) {
            target.setLineHeight(new Float(ParserUtil.parseFloat((String)attr.getValue(LINEHEIGHT), (float)0.0f)));
        }
        return target;
    }

    public static class FontInformation {
        private String fontname;
        private Integer fontSize;
        private Boolean isBold;
        private Boolean isItalic;
        private Boolean isStrikeThrough;
        private Boolean isUnderlined;
        private Boolean isEmbedded;
        private String fontencoding;
        private Float lineHeight;

        public Boolean getBold() {
            return this.isBold;
        }

        public Boolean getEmbedded() {
            return this.isEmbedded;
        }

        public Integer getFontSize() {
            return this.fontSize;
        }

        public String getFontencoding() {
            return this.fontencoding;
        }

        public String getFontname() {
            return this.fontname;
        }

        public Boolean getItalic() {
            return this.isItalic;
        }

        public Float getLineHeight() {
            return this.lineHeight;
        }

        public Boolean getStrikeThrough() {
            return this.isStrikeThrough;
        }

        public Boolean getUnderlined() {
            return this.isUnderlined;
        }

        public void setBold(Boolean bold) {
            this.isBold = bold;
        }

        public void setEmbedded(Boolean embedded) {
            this.isEmbedded = embedded;
        }

        public void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public void setFontencoding(String fontencoding) {
            this.fontencoding = fontencoding;
        }

        public void setFontname(String fontname) {
            this.fontname = fontname;
        }

        public void setItalic(Boolean italic) {
            this.isItalic = italic;
        }

        public void setLineHeight(Float lineHeight) {
            this.lineHeight = lineHeight;
        }

        public void setStrikeThrough(Boolean strikeThrough) {
            this.isStrikeThrough = strikeThrough;
        }

        public void setUnderlined(Boolean underlined) {
            this.isUnderlined = underlined;
        }
    }
}

