/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.Group;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.EmptyDataSource;
import org.jfree.report.filter.templates.Template;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateCollector;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.DataSourceWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.modules.parser.extwriter.StyleWriter;
import org.jfree.report.modules.parser.extwriter.TemplateWriter;
import org.jfree.report.modules.parser.extwriter.TemplatesWriter;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleKey;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;
import org.jfree.xml.writer.AttributeList;

public class ReportDescriptionWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath REPORT_DESCRIPTION_HINT_PATH = new CommentHintPath(new String[]{"report-definition", "report-description"});
    static /* synthetic */ Class class$java$lang$String;

    public ReportDescriptionWriter(ReportWriter reportWriter, int indent) {
        super(reportWriter, indent);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private boolean isBandEmpty(Band b) {
        if (b.getElementCount() != 0) {
            return false;
        }
        Iterator it = b.getStyle().getDefinedPropertyNames();
        if (!it.hasNext()) {
            return false;
        }
        StyleKey o = (StyleKey)it.next();
        return o.equals(BandLayoutManager.LAYOUTMANAGER) && !it.hasNext();
    }

    private boolean isGroupEmpty(Group g) {
        if (!g.getFields().isEmpty()) {
            return false;
        }
        if (!this.isBandEmpty(g.getFooter())) {
            return false;
        }
        return this.isBandEmpty(g.getHeader());
    }

    private boolean isStyleSheetEmpty(ElementStyleSheet es) {
        return es.getParents().length == 0 && !es.getDefinedPropertyNames().hasNext();
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        this.writeComment(writer, REPORT_DESCRIPTION_HINT_PATH, "parser.comment.open");
        this.writeTag(writer, "report-description");
        this.writeBand(writer, "report-header", this.getReport().getReportHeader(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeBand(writer, "report-footer", this.getReport().getReportFooter(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeBand(writer, "page-header", this.getReport().getPageHeader(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeBand(writer, "page-footer", this.getReport().getPageFooter(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeBand(writer, "watermark", this.getReport().getWatermark(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeGroups(writer);
        this.writeBand(writer, "itemband", this.getReport().getItemBand(), REPORT_DESCRIPTION_HINT_PATH);
        this.writeComment(writer, REPORT_DESCRIPTION_HINT_PATH, "parser.comment.close");
        this.writeCloseTag(writer, "report-description");
    }

    private void writeBand(Writer writer, String tagName, Band band, CommentHintPath path) throws IOException, ReportWriterException {
        if (this.isBandEmpty(band)) {
            return;
        }
        CommentHintPath newPath = path.getInstance();
        newPath.addName(band);
        this.writeComment(writer, newPath, "parser.comment.open");
        if (band.getName().startsWith("anonymousBand@")) {
            this.writeTag(writer, tagName);
        } else {
            this.writeTag(writer, tagName, "name", band.getName(), false);
        }
        ElementStyleSheet styleSheet = band.getStyle();
        if (!this.isStyleSheetEmpty(styleSheet)) {
            CommentHintPath stylePath = newPath.getInstance();
            stylePath.addName("style");
            this.writeComment(writer, stylePath, "parser.comment.open");
            this.writeTag(writer, "style");
            StyleWriter styleWriter = new StyleWriter(this.getReportWriter(), band.getStyle(), this.getIndentLevel(), stylePath);
            styleWriter.write(writer);
            this.writeComment(writer, stylePath, "parser.comment.close");
            this.writeCloseTag(writer, "style");
        }
        this.writeDataSourceForElement(band, writer, newPath);
        Element[] list = band.getElementArray();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof Band) {
                Band b = (Band)list[i];
                this.writeBand(writer, "band", b, newPath);
            } else {
                this.writeElement(writer, list[i], band, newPath);
            }
            ++i;
        }
        this.writeComment(writer, newPath, "parser.comment.close");
        this.writeCloseTag(writer, tagName);
    }

    private void writeDataSource(Writer writer, DataSource datasource, CommentHintPath path) throws IOException, ReportWriterException {
        ObjectDescription od = this.getReportWriter().getClassFactoryCollector().getDescriptionForClass(datasource.getClass());
        if (od == null) {
            od = this.getReportWriter().getClassFactoryCollector().getSuperClassObjectDescription(datasource.getClass(), null);
        }
        if (od == null) {
            throw new ReportWriterException("Unable to resolve DataSource: " + datasource.getClass());
        }
        DataSourceCollector dataSourceCollector = this.getReportWriter().getDataSourceCollector();
        String dsname = dataSourceCollector.getDataSourceName(od);
        if (dsname == null) {
            throw new ReportWriterException("No name for DataSource " + datasource);
        }
        CommentHintPath dataSourcePath = path.getInstance();
        dataSourcePath.addName("datasource");
        this.writeComment(writer, dataSourcePath, "parser.comment.open");
        this.writeTag(writer, "datasource", "type", dsname, false);
        DataSourceWriter dsWriter = new DataSourceWriter(this.getReportWriter(), datasource, od, this.getIndentLevel(), dataSourcePath);
        dsWriter.write(writer);
        this.writeComment(writer, dataSourcePath, "parser.comment.close");
        this.writeCloseTag(writer, "datasource");
    }

    protected void writeDataSourceForElement(Element element, Writer writer, CommentHintPath path) throws ReportWriterException, IOException {
        TemplateDescription parent;
        String templateExtends;
        Template template;
        if (element.getDataSource() instanceof EmptyDataSource) {
            return;
        }
        if (!(element.getDataSource() instanceof Template)) {
            this.writeDataSource(writer, element.getDataSource(), path);
            return;
        }
        TemplateCollector tc = this.getReportWriter().getTemplateCollector();
        TemplateDescription templateDescription = tc.getDescription(template = (Template)element.getDataSource());
        if (templateDescription == null) {
            throw new ReportWriterException("Unknown template type: " + template);
        }
        TemplateDescription parentTemplate = (TemplateDescription)templateDescription.getInstance();
        try {
            templateDescription.setParameterFromObject(template);
        }
        catch (ObjectFactoryException ofe) {
            throw new ReportWriterException("Error while preparing the template", (Exception)((Object)ofe));
        }
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints != null && (templateExtends = (String)hints.getHint(element, "ext.parser.template-reference", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ReportDescriptionWriter.class$("java.lang.String")))) != null && (parent = TemplatesWriter.getTemplateDescription(this.getReportWriter(), templateExtends)) != null) {
            parentTemplate = parent;
        }
        CommentHintPath templatePath = path.getInstance();
        templatePath.addName("template");
        TemplateWriter templateWriter = new TemplateWriter(this.getReportWriter(), this.getIndentLevel(), templateDescription, parentTemplate, templatePath);
        templateWriter.write(writer);
    }

    private void writeElement(Writer writer, Element element, Band parent, CommentHintPath path) throws IOException, ReportWriterException {
        if (parent.getElements().indexOf(element) == -1) {
            throw new IllegalArgumentException("The given Element is no child of the band");
        }
        CommentHintPath newPath = path.getInstance();
        newPath.addName(element);
        this.writeComment(writer, newPath, "parser.comment.open");
        AttributeList p = new AttributeList();
        if (!element.getName().startsWith("anonymousElement@")) {
            p.setAttribute("name", element.getName());
        }
        p.setAttribute("type", element.getContentType());
        this.writeTag(writer, "element", p, false);
        ElementStyleSheet styleSheet = element.getStyle();
        if (!this.isStyleSheetEmpty(styleSheet)) {
            CommentHintPath stylePath = newPath.getInstance();
            stylePath.addName("style");
            this.writeComment(writer, stylePath, "parser.comment.open");
            this.writeTag(writer, "style");
            StyleWriter styleWriter = new StyleWriter(this.getReportWriter(), element.getStyle(), this.getIndentLevel(), stylePath);
            styleWriter.write(writer);
            this.writeComment(writer, stylePath, "parser.comment.close");
            this.writeCloseTag(writer, "style");
        }
        this.writeDataSourceForElement(element, writer, newPath);
        this.writeComment(writer, newPath, "parser.comment.close");
        this.writeCloseTag(writer, "element");
    }

    private void writeGroups(Writer writer) throws IOException, ReportWriterException {
        CommentHintPath groupsPath = REPORT_DESCRIPTION_HINT_PATH.getInstance();
        groupsPath.addName("groups");
        this.writeComment(writer, groupsPath, "parser.comment.open");
        this.writeTag(writer, "groups");
        int groupSize = this.getReport().getGroupCount();
        int i = 0;
        while (i < groupSize) {
            Group g = this.getReport().getGroup(i);
            if (!this.isGroupEmpty(g)) {
                CommentHintPath groupPath = groupsPath.getInstance();
                groupPath.addName(g);
                this.writeComment(writer, groupPath, "parser.comment.open");
                this.writeTag(writer, "group", "name", g.getName(), false);
                List fields = g.getFields();
                if (!fields.isEmpty()) {
                    CommentHintPath fieldsPath = groupPath.getInstance();
                    fieldsPath.addName("fields");
                    this.writeComment(writer, fieldsPath, "parser.comment.open");
                    this.writeTag(writer, "fields");
                    int f = 0;
                    while (f < fields.size()) {
                        String field = (String)fields.get(f);
                        CommentHintPath fieldPath = fieldsPath.getInstance();
                        fieldPath.addName(field);
                        this.writeComment(writer, fieldPath, "parser.comment.open");
                        this.writeTag(writer, "field");
                        writer.write(AbstractXMLDefinitionWriter.normalize(field));
                        this.writeCloseTag(writer, "field");
                        ++f;
                    }
                    this.writeComment(writer, fieldsPath, "parser.comment.close");
                    this.writeCloseTag(writer, "fields");
                }
                this.writeBand(writer, "group-header", g.getHeader(), groupPath);
                this.writeBand(writer, "group-footer", g.getFooter(), groupPath);
                this.writeComment(writer, groupPath, "parser.comment.close");
                this.writeCloseTag(writer, "group");
            }
            ++i;
        }
        this.writeComment(writer, groupsPath, "parser.comment.close");
        this.writeCloseTag(writer, "groups");
    }
}

