/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.util.Log;
import org.jfree.report.util.PageFormatFactory;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriterSupport;

public class ReportConfigWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath REPORT_CONFIG_HINT_PATH = new CommentHintPath(new String[]{"report-definition", "report-config"});
    private static final CommentHintPath CONFIGURATION_HINT_PATH = new CommentHintPath(new String[]{"report-definition", "report-config", "configuration"});
    private static final CommentHintPath DEFAULT_PAGEFORMAT_HINT_PATH = new CommentHintPath(new String[]{"report-definition", "report-config", "defaultpageformat"});
    private static final int TOP_BORDER = 0;
    private static final int LEFT_BORDER = 1;
    private static final int BOTTOM_BORDER = 2;
    private static final int RIGHT_BORDER = 3;
    static /* synthetic */ Class class$org$jfree$report$util$PageFormatFactory;

    public ReportConfigWriter(ReportWriter reportWriter, int indentLevel) {
        super(reportWriter, indentLevel);
    }

    private AttributeList buildPageFormatProperties() {
        AttributeList retval = new AttributeList();
        PageFormat fmt = this.getReport().getPageDefinition().getPageFormat(0);
        int[] borders = this.getBorders(fmt.getPaper());
        if (fmt.getOrientation() == 0) {
            retval.setAttribute("orientation", "landscape");
            retval.setAttribute("topmargin", String.valueOf(borders[3]));
            retval.setAttribute("leftmargin", String.valueOf(borders[0]));
            retval.setAttribute("bottommargin", String.valueOf(borders[1]));
            retval.setAttribute("rightmargin", String.valueOf(borders[2]));
        } else if (fmt.getOrientation() == 1) {
            retval.setAttribute("orientation", "portrait");
            retval.setAttribute("topmargin", String.valueOf(borders[0]));
            retval.setAttribute("leftmargin", String.valueOf(borders[1]));
            retval.setAttribute("bottommargin", String.valueOf(borders[2]));
            retval.setAttribute("rightmargin", String.valueOf(borders[3]));
        } else {
            retval.setAttribute("orientation", "reverselandscape");
            retval.setAttribute("topmargin", String.valueOf(borders[1]));
            retval.setAttribute("leftmargin", String.valueOf(borders[2]));
            retval.setAttribute("bottommargin", String.valueOf(borders[3]));
            retval.setAttribute("rightmargin", String.valueOf(borders[0]));
        }
        int w = (int)fmt.getPaper().getWidth();
        int h = (int)fmt.getPaper().getHeight();
        String pageDefinition = this.lookupPageDefinition(w, h);
        if (pageDefinition != null) {
            retval.setAttribute("pageformat", pageDefinition);
        } else {
            retval.setAttribute("width", String.valueOf(w));
            retval.setAttribute("height", String.valueOf(h));
        }
        return retval;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private int[] getBorders(Paper p) {
        int[] retval = new int[]{(int)p.getImageableY(), (int)p.getImageableX(), (int)(p.getHeight() - (p.getImageableY() + p.getImageableHeight())), (int)(p.getWidth() - (p.getImageableX() + p.getImageableWidth()))};
        return retval;
    }

    public String lookupPageDefinition(int w, int h) {
        try {
            Field[] fields = (class$org$jfree$report$util$PageFormatFactory != null ? class$org$jfree$report$util$PageFormatFactory : (class$org$jfree$report$util$PageFormatFactory = ReportConfigWriter.class$("org.jfree.report.util.PageFormatFactory"))).getFields();
            int i = 0;
            while (i < fields.length) {
                int[] pageDef;
                Object o;
                Field f = fields[i];
                if (Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && (o = f.get(PageFormatFactory.getInstance())) instanceof int[] && (pageDef = (int[])o)[0] == w && pageDef[1] == h) {
                    return f.getName();
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.info("Unable to translate the page size", e);
        }
        return null;
    }

    public void write(Writer writer) throws IOException {
        this.writeComment(writer, REPORT_CONFIG_HINT_PATH, "parser.comment.open");
        this.writeTag(writer, "report-config");
        this.writeComment(writer, DEFAULT_PAGEFORMAT_HINT_PATH, "parser.comment.open");
        this.writeTag(writer, "defaultpageformat", this.buildPageFormatProperties(), true);
        ReportConfiguration config = this.getReport().getReportConfiguration();
        Enumeration properties = config.getConfigProperties();
        if (properties.hasMoreElements()) {
            this.writeComment(writer, CONFIGURATION_HINT_PATH, "parser.comment.open");
            this.writeTag(writer, "configuration");
            while (properties.hasMoreElements()) {
                String key = (String)properties.nextElement();
                String value = config.getConfigProperty(key);
                if (value == null) continue;
                CommentHintPath path = CONFIGURATION_HINT_PATH.getInstance();
                path.addName(key);
                this.writeComment(writer, path, "parser.comment.open");
                this.writeTag(writer, "property", "name", key, false);
                writer.write(AbstractXMLDefinitionWriter.normalize(value));
                this.writeCloseTag(writer, "property");
            }
            this.writeComment(writer, CONFIGURATION_HINT_PATH, "parser.comment.close");
            this.writeCloseTag(writer, "configuration");
        }
        this.writeComment(writer, REPORT_CONFIG_HINT_PATH, "parser.comment.close");
        this.writeCloseTag(writer, "report-config");
        writer.write(XMLWriterSupport.getLineSeparator());
    }
}

