/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.util.Log;
import org.jfree.report.util.PageFormatFactory;
import org.jfree.xml.ParseException;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverselandscape";
    private float x;
    private float y;
    private PageFormat pageFormat;

    private PageFormat createPageFormat(PageFormat format, Attributes atts) throws SAXException {
        int orientationVal;
        String pageformatName = atts.getValue(PAGEFORMAT_ATT);
        String orientation = atts.getValue(ORIENTATION_ATT);
        if (orientation == null) {
            orientationVal = 1;
        } else if (orientation.equals(ORIENTATION_LANDSCAPE_VAL)) {
            orientationVal = 0;
        } else if (orientation.equals(ORIENTATION_REVERSE_LANDSCAPE_VAL)) {
            orientationVal = 2;
        } else if (orientation.equals(ORIENTATION_PORTRAIT_VAL)) {
            orientationVal = 1;
        } else {
            throw new ParseException("Orientation value in REPORT-Tag is invalid.", this.getRootHandler().getLocator());
        }
        if (pageformatName != null) {
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatName);
            if (p == null) {
                Log.warn("Unable to create the requested Paper. " + pageformatName);
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        if (atts.getValue(WIDTH_ATT) != null && atts.getValue(HEIGHT_ATT) != null) {
            int[] pageformatData = new int[]{ParserUtil.parseInt((String)atts.getValue(WIDTH_ATT), (String)"No Width set"), ParserUtil.parseInt((String)atts.getValue(HEIGHT_ATT), (String)"No Height set")};
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatData);
            if (p == null) {
                Log.warn("Unable to create the requested Paper. Paper={" + pageformatData[0] + ", " + pageformatData[1] + "}");
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        Log.info("Insufficient Data to create a pageformat: Returned default.");
        return format;
    }

    public Object getObject() throws XmlReaderException {
        return null;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    private void handlePageFormat(Attributes atts) throws SAXException {
        JFreeReport report = (JFreeReport)this.getRootHandler().getHelperObject("::report");
        PageFormat format = report.getPageDefinition().getPageFormat(0);
        float defTopMargin = (float)format.getImageableY();
        float defBottomMargin = (float)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
        float defLeftMargin = (float)format.getImageableX();
        float defRightMargin = (float)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
        format = this.createPageFormat(format, atts);
        defTopMargin = ParserUtil.parseFloat((String)atts.getValue(TOPMARGIN_ATT), (float)defTopMargin);
        defBottomMargin = ParserUtil.parseFloat((String)atts.getValue(BOTTOMMARGIN_ATT), (float)defBottomMargin);
        defLeftMargin = ParserUtil.parseFloat((String)atts.getValue(LEFTMARGIN_ATT), (float)defLeftMargin);
        defRightMargin = ParserUtil.parseFloat((String)atts.getValue(RIGHTMARGIN_ATT), (float)defRightMargin);
        Paper p = format.getPaper();
        switch (format.getOrientation()) {
            case 1: {
                PageFormatFactory.getInstance().setBorders(p, defTopMargin, defLeftMargin, defBottomMargin, defRightMargin);
                break;
            }
            case 0: {
                PageFormatFactory.getInstance().setBorders(p, defRightMargin, defTopMargin, defLeftMargin, defBottomMargin);
                break;
            }
            case 2: {
                PageFormatFactory.getInstance().setBorders(p, defLeftMargin, defBottomMargin, defRightMargin, defTopMargin);
                break;
            }
            default: {
                Log.debug("Unexpected paper orientation.");
            }
        }
        format.setPaper(p);
        this.pageFormat = format;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        this.handlePageFormat(attrs);
        this.x = ParserUtil.parseFloat((String)attrs.getValue("x"), (float)0.0f);
        this.y = ParserUtil.parseFloat((String)attrs.getValue("y"), (float)0.0f);
    }

    protected void storeComments() throws SAXException {
        Object[] serializedPageFormat = PageFormatFactory.getInstance().resolvePageFormat(this.pageFormat);
        CommentHintPath path = new CommentHintPath(serializedPageFormat);
        this.defaultStoreComments(path);
    }
}

