/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import org.jfree.report.Group;
import org.jfree.report.GroupList;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.common.GroupFieldsReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.BandReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class GroupReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String GROUP_HEADER_TAG = "group-header";
    public static final String GROUP_FOOTER_TAG = "group-footer";
    public static final String FIELDS_TAG = "fields";
    public static final String FIELD_TAG = "field";
    private static final String NAME_ATT = "name";
    private GroupList groupList;
    private Group group;

    public GroupReadHandler(GroupList groupList) {
        this.groupList = groupList;
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        this.groupList.add(this.group);
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals(GROUP_HEADER_TAG)) {
            return new BandReadHandler(this.group.getHeader());
        }
        if (tagName.equals(GROUP_FOOTER_TAG)) {
            return new BandReadHandler(this.group.getFooter());
        }
        if (tagName.equals(FIELDS_TAG)) {
            return new GroupFieldsReadHandler(this.group);
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.group;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String groupName = attrs.getValue(NAME_ATT);
        if (groupName != null) {
            JFreeReport report = (JFreeReport)this.getRootHandler().getHelperObject("::report");
            this.group = report.getGroupByName(groupName);
            if (this.group == null) {
                this.group = new Group();
                this.group.setName(groupName);
            }
        } else {
            this.group = new Group();
        }
    }

    protected void storeComments() throws SAXException {
        CommentHintPath hintPath = new CommentHintPath(this.group);
        this.defaultStoreComments(hintPath);
    }
}

